<?php

namespace App\Exports;

use App\Models\Classroom;
use App\Models\Exam;
use App\Models\Subject;
use App\Models\Trimester;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Date;
use Maatwebsite\Excel\Concerns\WithFooter;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup\Image;

class StudentMarks implements FromView, ShouldAutoSize, WithEvents
{
    private $condition;
    public $schoolName, $subjectName, $className, $students;

    public function __construct($condition)
    {
        $this->condition = $condition;
        $this->schoolName = 'COLÉGIO POLITÉCNICO DE MOÇAMBIQUE'; // Replace with your school name
        $this->subjectName = Subject::query()->where('id', $this->condition['subject_id'])->first()->name; // Fetch subject name
        $this->className = Classroom::query()->where('id', $this->condition['class_id'])->first()->name; // Fetch class name
    }

    public function view(): View
    {
        return view('exports.studentsmark', [
            'models' => Exam::query()
                ->with(['subject'])
                ->latest('created_at')
                ->where('classroom_id', $this->condition['class_id'])
                ->where('trimester_id', 1)
                ->where('subject_id', $this->condition['subject_id'])
                ->where('exams.year', $this->condition['year'])
                ->get(),
            'class_id' => $this->condition['class_id'],
            'subjectnamee' => $this->subjectName,
        ]);
    }
    
    public function registerEvents(): array
    {
        $logoPath = public_path('assets/images/logo.png');

        return [
            AfterSheet::class => function (AfterSheet $event) use ($logoPath) {
                // Set the height of the logo row
                $event->sheet->getRowDimension(1)->setRowHeight(80); // Adjust image height as needed
                // Create a drawing and set the image
                $drawing = new Drawing();
                $drawing->setPath($logoPath);
                $drawing->setWorksheet($event->sheet->getDelegate());
                $drawing->setCoordinates('D1'); // Adjust the cell coordinates as needed
                $drawing->setHeight(80); // Adjust image height as needed
                // Add the school name in the same cell as the logo
                $trimesterNameCell = $event->sheet->getCell('G1');
                $trimesterNameCell->setValue('1º Trimestre'); // Use the school name from the view
                // Add the school name in the same cell as the logo
                $schoolNameCell = $event->sheet->getCell('D1');
                $schoolNameCell->setValue($this->schoolName); // Use the school name from the view
                // Add the school name in the same cell as the logo
                $subjectNameCell = $event->sheet->getCell('B1');
                $subjectNameCell->setValue($this->subjectName); // Use the school name from the view
                // Add the school name in the same cell as the logo
                $classNameCell = $event->sheet->getCell('C1');
                $classNameCell->setValue($this->className); // Use the school name from the view
                // Add the school name in the same cell as the logo
                $trime3NameCell = $event->sheet->getCell('S1');
                $trime3NameCell->setValue('3º Trimestre'); // Use the school name from the view
                // Add the school name in the same cell as the logo
                $trime2NameCell = $event->sheet->getCell('M1');
                $trime2NameCell->setValue('2º Trimestre'); // Use the school name from the view
                // Remove the background color of the first row
                $event->sheet->getStyle('1:1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_NONE);
                // Set font color for the first row
                $event->sheet->getStyle('1:1')->getFont()->getColor()
                    ->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_BLACK);
                // Make the first row bold
                $event->sheet->getStyle('1:1')->getFont()->setBold(true);
            },
        ];
    }

    public function headings(): array
    {
        return [
            'Subject: ' . $this->subjectName,
            'Class: ' . $this->className,
            '', // Add more columns as needed
        ];
    }
}
