<?php

namespace App\Http\Livewire\Admin\Reports;
use App\Models\Admin;
use App\Models\Classroom;
use App\Models\User;
use App\Models\Payment;
use App\Models\Project;
use App\Models\Subject;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Note\Note;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\ExportExams;
use App\Exports\StudentMarks;
use App\Models\TeacherSubject;

class GenerateSubjectCombine extends Component
{
    use FindGuard, LivewireAlert;

    public $trimester_id;
    public $class_id;
    public $user_id, $class, $year;
    public $subject_id;
    public $report = [];
    public $reports;
    public bool $readyToLoad = false;

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function loadReport()
    {
        $this->readyToLoad = true;
    }

    protected array $rules = [
        'user_id' => ['string', 'nullable'],
        'class_id' => ['string', 'required'],
         'class' => ['string', 'required'],
        'subject_id' => ['string', 'required']
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }
    /**
     * generate report
     * @throws Exception
     */
    public function generateReport()
    {
        $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        Note::createSystemNotification(Admin::class, 'Relatório final de cada disciplina', 'Relatório gerado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Relatório gerado com sucesso ');
        $condition = ['class_id' => $this->class_id, 'subject_id'=> $this->subject_id, 'year'=>$this->year];
        return Excel::download(new StudentMarks($condition), Subject::query()->where('id',  $this->subject_id)->first()->name.'.xlsx');
        //get the id
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    

    public function render()
    {
        $this->user = $this->findGuardType()->user();
        $ccclass = ($this->class) ? $this->class : '1';
    
        $classroom = Classroom::where('class', $ccclass)->firstOrFail(); // Busca a sala de aula
    

       // Busca os estudantes e ordena manualmente os alunos por nome
       $students = $classroom->students()->get()->sortBy('name')->values();
    
        // Verifica a lista de nomes ordenados
        $sortedNames = $students->pluck('name');
        //dd($sortedNames);
    
        return view('livewire.admin.reports.generate-subject-combine', [
            'subjects' => Subject::join('teacher_subjects', 'subjects.id', '=', 'teacher_subjects.subject_id')
                ->select('subjects.id', 'subjects.name', 'subjects.slug')
                ->where('teacher_subjects.class', $ccclass)
                ->orderBy('subjects.name')
                ->distinct()
                ->get(),
            'classes' => Classroom::where('class', $this->class)->get(),
            'teacher' => TeacherSubject::where("teacher_id", $this->user->id)->get(),
            'students' => $students, // Passa os alunos ordenados para a view
        ]);
    }
}
