<?php

namespace App\Http\Livewire\Admin\Students;

use App\Models\User;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;

class ListPaidStudents extends Component
{
    protected $lazy = false;
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete;

    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled',
        'complete'
    ];

    public function submit($id)
    {
        $this->delete = User::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function submitcomplete($id)
    {
        $this->delete = User::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja marcar como não pago?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'complete',
            'onDismissed' => 'cancelled'
        ]);
    }
    public function complete()
    {
        User::query()
            ->where('id', $this->delete->id)
            ->update([
                'is_paid' => false,
            ]);
        Note::createSystemNotification(User::class, 'Estudante', 'Marcado como não pago com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Marcado como não pago com sucesso ');
        return back();
    }
    public function confirmed()
    {
        //check if already enrolled
        $check = User::query()->where('model_id', $this->delete->id)->get();
        if (count($check) >= 1) {
            $this->alert('warning', 'Desculpe, este modelo tem subscritores.');
            return back();
        }
        User::where('id', $this->delete->id)->delete();
        Note::createSystemNotification(Admin::class, 'Estudante', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
        $this->reset();


    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        return view('livewire.admin.students.list-paid-students', [
                'models' => $this->readyToLoad
                    ? User::query()
                        ->orderBy('name') // Order by the 'name' column in alphabetical order
                        ->where('is_paid', true)
                        ->where(function ($query) {
                            $query->orWhere('name', 'like', '%' . $this->search . '%')
                                ->orWhere('slug', 'like', '%' . $this->search . '%');
                        })
                        ->paginate(10)
                    : []
            ]
        );
    }

}
