<?php

namespace App\Http\Livewire\Auth;

use App\Models\User;
use Illuminate\Http\RedirectResponse;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;

class Verify extends Component
{
    use LivewireAlert;

    public function mount(string $slug): RedirectResponse
    {
        if (!request()->hasValidSignature()) {
            $this->alert('warning', 'Este link é inválido.');
            return redirect()->route('login');
        }

        $user = User::query()->firstWhere('slug', $slug);
        if ($user) {
            $user->update([
                'email_verified_at' => now()
            ]);
            auth()->login($user);
            return redirect()->route('user.home');
        }
        return redirect()->route('login');
    }

    public function render()
    {
        return view('livewire.auth.verify')->layout('layouts.auth');
    }
}
