<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;


class Exam extends Model
{
    use HasFactory, Uuids, SoftDeletes;

    /**
     * stop the autoincrement
     */
    public $incrementing = false;

    /**
     * type of auto-increment
     *
     * @string
     */
    protected $keyType = 'string';

    protected $fillable = [
        'student_id',
        'subject_id',
        'MACS',
        'classroom_id',
        'trimester_id',
        'ACS1a',
	    'year',
        'ACS2a',
        'AT',
        'MT',
        'NE',
    ];

    /**
     * user
     * @return BelongsTo
     */
    public function student(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
        /**
     * user
     * @return BelongsTo
     */
    public function subject(): BelongsTo
    {
        return $this->belongsTo(Subject::class,'subject_id');
    }
            /**
     * user
     * @return BelongsTo
     */
    public function class(): BelongsTo
    {
        return $this->belongsTo(Classroom::class,'classroom_id');
    }
}
