<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Editar livro</h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Title</label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror"
                                        id="title" required placeholder="Enter  title..."  name="title" wire:model="title" >
                                    @error('title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                    <div class="col-md-6">
                                    <label for="author" class="form-label">Author</label>
                                    <input type="text" class="form-control @error('author') is-invalid @enderror"
                                        id="author" required placeholder="Enter  author..."  name="author" wire:model="author" >
                                    @error('author')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-md-12">
                                    <label for="title" class="form-label">Disciplina/Categoria </label>
                                    <select class="form-control @error('category_id') is-invalid @enderror"
                                            id="name" wire:model="category_id"
                                            class="form-control input-lg dynamic">
                                        <option value="">Seleciona a disciplina/categoria</option>
                                        @foreach($subjects as $subject)
                                            <option value="{{ $subject->id }}"> {{ $subject->name }} </option>
                                        @endforeach
                                    </select>
                                    @error('category_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-12" wire:model.debounce.365ms="description" wire:ignore>
                                    <label for="description" class="form-label"><b> Descrição</b></label>
                                    <input id="description"
                                           value="{{ $description }}"
                                           type="hidden"
                                           name="description">
                                    <trix-editor
                                        input="description"></trix-editor>
                                    @error('description')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div wire:loading wire:target="photo"><span
                                    class="spinner-border spinner-border-sm"></span> Carregando...
                            </div>
                            <div class="col-md-12">
                                <label for="photo" class="form-label"> Imagem</label>
                                <input type="file" class="form-control @error('photo') is-invalid @enderror"
                                    name="photo"   wire:model ="photo" placeholder="Carregar imagem...">
                                @error('photo')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                              <div class="col-md-12">
                                <label for="pdf" class="form-label"> Pdf</label>
                                <input type="file" class="form-control @error('pdf') is-invalid @enderror"
                                    name="pdf"   wire:model ="pdf" placeholder="Upload pdf...">
                                @error('pdf')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled"><span wire:target="submit"
                                                                               wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Guardar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
