<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title"> Notas do Estudante: {{$model->name}} </h5>
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="search" wire:model="search" placeholder="Pesquisar..."
                                           class="form-control">
                                </div>     
                                <div class="mt-3">
                                    <label for="selectedYear" class="block font-medium text-sm text-gray-700">Selecionar ano lectivo</label>
                                    <select wire:model="selectedYear" id="selectedYear" name="selectedYear"
                                            class="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                        @for ($year = date('Y'); $year >= 2023; $year--)
                                            <option value="{{ $year }}">{{ $year }}</option>
                                        @endfor
                                    </select>
                                </div>     
                            
                        </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="table-responsive" wire:init="loadData">
                                        @if(count($models))
                                            <table class="table table-hover">
                                                <thead>
                                                    <th colspan="2" ><b>Primeiro Trimestre</b></th>
                                                    <tr>
                                                        <th scope="col">Disciplina</th>
                                                        <th scope="col">ASC1</th>
                                                        <th scope="col">ASC2</th>
                                                        <th scope="col">MACS</th>
                                                        <th scope="col">AT</th>
                                                        <th scope="col">Editar</th>

                                                </tr>
                                                </thead>
                                                <tbody>
                                                @php($count = 1)
                                                @foreach($models->where('trimester_id', 1) as $model)
                                                    <tr>
                                                        <td>{{ $model->subject->name }}</td>
                                                        <td>{{ $model->ACS1a }}</td>
                                                        <td>{{ $model->ACS2a }}</td>
                                                        <td>{{ ($model->ACS2a + $model->ACS1a) * 0.5 }}</td>
                                                        <td>{{ $model->AT  }}</td>
                                                        <td><a href="{{route('admin.edit.student.exam', $model->id)}}"
                                                            class="btn btn-outline-primary"><span
                                                                 class="fa fa-edit"></span></a>

                                                     </td>
                                                    </tr>
                                                  @endforeach
                                                </tbody>
                                            </table>
                                            <div class="row float-end">
                                                {{ $models->links() }}
                                            </div>
                                        @else
                                            <br>
                                            <br>
                                            <div  class="d-flex justify-content-center">
                                                <div wire:loading class="spinner-border text-primary" role="status">
                                                    <span class="sr-only">Processando...</span>
                                                </div>
                                            </div>
                                            <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="table-responsive" wire:init="loadData">
                                        @if(count($models))
                                            <table class="table table-hover">
                                                <thead>
                                                    <th colspan="2"><b>Segundo Trimestre</b></th>
                                                    <tr>
                                                        <th scope="col">Disciplina</th>
                                                        <th scope="col">ASC1</th>
                                                        <th scope="col">ASC2</th>
                                                        <th scope="col">MACS</th>
                                                        <th scope="col">AT</th>
							                            <th scope="col">Editar</th>    
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                @php($count = 1)
                                                @foreach($models->where('trimester_id', 2) as $model)
                                                    <tr>
                                                        <td>{{ $model->subject->name }}</td>
                                                        <td>{{ $model->ACS1a }}</td>
                                                        <td>{{ $model->ACS2a }}</td>
                                                        <td>{{ ($model->ACS2a + $model->ACS1a) * 0.5 }}</td>
                                                        <td>{{ $model->AT  }}</td>
                                                        <td><a href="{{route('admin.edit.student.exam', $model->id)}}"
                                                            class="btn btn-outline-primary"><span
                                                                 class="fa fa-edit"></span></a>
                                                     </td>

                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                            <div class="row float-end">
                                                {{ $models->links() }}
                                            </div>
                                        @else
                                            <br>
                                            <br>
                                            <div  class="d-flex justify-content-center">
                                                <div wire:loading class="spinner-border text-primary" role="status">
                                                    <span class="sr-only">Processando...</span>
                                                </div>
                                            </div>
                                            <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="table-responsive" wire:init="loadData">
                                        @if(count($models))
                                            <table class="table table-hover">
                                                <thead>
                                                    <th colspan="2"><b>Terceiro Trimestre</b></th>
                                                <tr>
                                                    <th scope="col">Disciplina</th>
                                                    <th scope="col">ASC1</th>
                                                    <th scope="col">ASC2</th>
                                                    <th scope="col">MACS</th>
                                                    <th scope="col">AT</th>
						                            <th scope="col">Editar</th>


                                                </tr>
                                                </thead>
                                                <tbody>
                                                @php($count = 1)
                                                @foreach($models->where('trimester_id', 3) as $model)
                                                    <tr>
                                                        <td>{{ $model->subject->name }}</td>
                                                        <td>{{ $model->ACS1a }}</td>
                                                        <td>{{ $model->ACS2a }}</td>
                                                        <td>{{ ($model->ACS2a + $model->ACS1a) * 0.5 }}</td>

                                                        <td>{{ $model->AT  }}</td>
                                                        <td><a href="{{route('admin.edit.student.exam', $model->id)}}"
                                                            class="btn btn-outline-primary"><span
                                                                 class="fa fa-edit"></span></a>
                                                     </td>


                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                            <div class="row float-end">
                                                {{ $models->links() }}
                                            </div>
                                        @else
                                            <br>
                                            <br>
                                            <div  class="d-flex justify-content-center">
                                                <div wire:loading class="spinner-border text-primary" role="status">
                                                    <span class="sr-only">Processando...</span>
                                                </div>
                                            </div>
                                            <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
