<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title"> Lista de comunicados</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    <!---input type="search" wire:model="search" placeholder="Pesquisar..."
                                           class="form-control"--->
                                </div>
                            </div>

                            <div class="table-responsive" wire:init="loadData">
                                @if(count($models))
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Para</th>
                                            <th scope="col">Classe</th>
                                            <th scope="col">Estudante</th>
                                            <th scope="col">Descrição</th>        
                                            <th scope="col">Ficheiro</th>
                                            <th scope="col">Data de lançamento</th>
                                            <th scope="col">Acção</th>
                                            
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @php($count = 1)
                                        @foreach($models as $model)
                                        <?php 
                                        if(!empty($model->class_id)){
                                            $get_class = \App\Models\Classroom::query()->where("id",$model->class_id)->first() ?? 0;
                                            //dd($get_class);
                                        }
                                        if(!empty($model->student_id)){
                                            $get_student = \App\Models\User::query()->where("id",$model->student_id)->first() ?? 0;
                                        }
                                        
                                        
                                        //dd($get_file);
                                        if(isset($student)){ 
                                            $user = Auth::user();
                                            if(empty($model->student_id) || $model->student_id == $user->id  ){
                                                if($model->type == "all"){
                                                    $title = "Todos";
                                                }elseif($model->type == "student"){
                                                    $title = "Estudante";
                                                }elseif($model->type == "class"){
                                                    $title = "Classe";
                                                }
                                            ?>
                                            <tr>
                                                <th scope="row">{{ $count++ }}</th>
                                                <td>{{ $title }}</td>
                                                <td>
                                                    @if(!empty($model->class_id))
                                                    {{ $get_class->class }} class {{ $get_class->name }}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if(!empty($model->student_id))
                                                    {!! $get_student->name !!}
                                                    @endif
                                                </td>
                                                <td>{!! $model->title !!}</td>
                                                
                                                <td><a href="{{ $model->media_url }}" >{{ $model->media_name }}</a></td>
                                                
                                            </tr>
                                            <?php
                                            }
                                        }else{
                                             if($model->type == "all"){
                                                    $title = "Todos";
                                                }elseif($model->type == "student"){
                                                    $title = "Estudante";
                                                }elseif($model->type == "class"){
                                                    $title = "Classe";
                                                }
                                        ?>
                                            <tr>
                                                <th scope="row">{{ $count++ }}</th>
                                                <td>{{ $title }}</td>
                                                <td>
                                                    @if(!empty($model->class_id))
                                                    {{ $get_class->class }} class {{ $get_class->name }}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if(!empty($model->student_id))
                                                    {!! $get_student->name !!}
                                                    @endif
                                                </td>
                                                <td>{!! $model->title !!}</td>
                                              
                                                <td><a href="{{ $model->media_url }}" >{{ $model->media_name }}</a></td>
                                                <td>{{ \Carbon\Carbon::parse($model->created_at)->format('d/m/Y H:i:s') }}</td>
                                                <td>
                                                    <a href="{{ route('admin.edit.payment', $model->slug) }}"
                                                        class="btn btn-block btn-outline-primary btn-sm"><span
                                                            class="fa fa-edit"></span>
                                                    </a>
                                                    <a type="button" wire:click="submit('{{ $model->slug }}')"
                                                        class="btn btn-outline-danger"><span class="fa fa-trash"></span></a>
                                                    
                                                </td>
                                                
                                            </tr>

                                           <?php } ?> 
                                        @endforeach
                                        </tbody>
                                    </table>
                                    <div class="d-flex justify-content-center">
            {{ $models->links() }}
        </div>    
                                @else
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
