<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title"> Lista de estudantes</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="search" wire:model="search" placeholder="Pesquisar..."
                                           class="form-control">
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                <?php if(count($models)): ?>
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Nome</th>
                                            <th scope="col">Sexo</th>
                                            <th scope="col">Data de nascimento</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">ID do Estudante</th>
                                            <th scope="col">Estado</th>
                                             <th scope="col">Classe</th>
                                            <th scope="col">Turma</th>
                                            <th scope="col">Editar</th>
                                            <th scope="col">Deletar</th>
                                            

                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php ($count = 1); ?>
                                        <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th scope="row"><?php echo e($count++); ?></th>
                                                <td><?php echo e($model->name); ?></td>
                                                <td><?php echo e($model->sex); ?></td>
                                                <td><?php echo e($model->dob); ?></td>
                                                <td><?php echo e($model->email); ?></td>
                                                <td><?php echo e($model->student_id); ?></td>
                                                <td>
                                                    <?php if($model->is_paid): ?>
                                                    <span  class="badge bg-success">Pago (regular)</span>
                                                    <?php else: ?>
                                                    <span  class="badge bg-danger">Não pago (irregular)</span>
                                                    <?php endif; ?>
                                                    </td>
                                                    
                                                    <td><?php echo e(optional($model->class)->class ?? ''); ?> Classe</td>
                                                    <td><?php echo e(optional($model->class)->name ?? ''); ?></td>
                                                   

                                                  <td><a class="btn btn-primary"
                                                        href="<?php echo e(route('admin.edit.student', $model->slug)); ?>">Editar</a></td>
                                                    <td><a class="btn btn-danger"
                                                        wire:click="submit('<?php echo e($model->id); ?>')"
                                                        href="#">Deletar</a></td>
                                                        <?php if($user->role==0): ?>
                                                        <td><a class="dropdown-item text-warning"
                                                            wire:click="submitcomplete('<?php echo e($model->id); ?>')"
                                                            href="#">Não pago (irregular)</a></td>
                                                            <?php else: ?>
                                                            <?php endif; ?>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        <?php echo e($models->links()); ?>

                                    </div>
                                <?php else: ?>
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<?php /**PATH /home/1165120.cloudwaysapps.com/ttmjqktapb/public_html/resources/views/livewire/admin/students/list-students.blade.php ENDPATH**/ ?>