<?php

namespace Chatify\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;
use App\Models\ChMessage as Message;
use App\Models\ChChannel as Channel;
use App\Models\ChFavorite as Favorite;
use Chatify\Facades\ChatifyMessenger as Chatify;
use App\Models\User;
use App\Models\Admin;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Illuminate\Support\Facades\Log;
use Kreait\Firebase\Exception\Messaging\NotFound;
use Kreait\Firebase\Factory;

class MessagesController extends Controller
{
    protected $perPage = 30;

     /**
     * Authinticate the connection for pusher
     *
     * @param Request $request
     * @return void
     */
    public function createNewChannel(Request $request)
    {
        $user = Auth::guard('api')->user();
        
        $firebaseCredentials = [
                "type"=> "service_account",
                "project_id"=> "copmoz-3x",
                "private_key_id"=> "7768bcef3df838b966f6ec0f3fd398ced9336439",
                "private_key"=> "-----BEGIN PRIVATE KEY-----\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDY12nvQbs5PGiU\nuZrrhOKpCB5viTy6PdNNB0vz8MRA+8SL4RaZG8b/AA9qgNRj03GMx3cP6OVFMi7C\n7/KRjjHJisfK0etOqfRc8IVrG4pizwmetMLdE1PsSNsHaC/mddLQKbKwsf8QhJGb\npSRI4PMdgSGmsvpn0L0ki7DhrdRF7d8NdFFLdrXTtULSmpWyh+Mvt9GApM/ffQh6\nAC0X04BANj449xCAJVFsjfDrXgN4/ZOOBUItLZK0ICDjuaf8009ABdxn28Y0oRQC\nIk4fbPtBcLhofFyXiGDV0XiAvgCioyM4eTPDLfU3d9NbgF7pHo2aust4qg2qt5/k\ncVKN4TMhAgMBAAECggEAMOaXdcTpj3VPkmavCLkNkpgJoRaectO5gLAKEWe1IoCE\nqRToTzwD6wLc9yQ5gY+wFlLvR0+60JmKER0io2+hS7W368XeXn2WZZU6SVbLJRBS\nt49FOK0AqpMdjfSRhNQCaD5XFWD2yAdVfPfHkIXmXbt+1sSbEulwljrId4SHkAMz\n+epUKT48svL+Kbdijz9zZjzw1LkX768tn4G+7vDNv2VgQnZbWHun0beOHvYesb7A\ncHQqT20B8wHRlVzUV5Mj61Tzgn84Oq+7TFwFkw/kYu3ErtP+Cwv+LWExnyeZ2ZMe\nvGPQRvN9BRbr5gyIJzc0FX9jPzfI/7lbdePVdgHNTwKBgQD3i9aSfBO+SiMsh3y8\nsBkE8sG6bP/lXk9ySLEV/3LFB9sRJpFOe4hCOvFY2wb0pHbVZd65o2FdmvRZm5DK\nrJA8oqByOIt9x9dBMIEQW4IrNNOeJwEflpagL/32KH4L16PPcf3CYZRLQCxVRMlm\n+FTTtGDpydnA/e8YO8weGU2aDwKBgQDgPyP1QiIbvotj9V3hNXYfiT88m/Al9roe\nHkQ2psE3YCz4BQGQ8xfPYmY3dDyHFegPLHHDiHMkvPTcFxt0S9P7k/eKOLBpgp9e\nihrNoDXBD5B0wgLQc1Mp4HYEeTnH9mEKOGURznOIF8X4uVY7+WzV56Rb38NZHIi7\nf0J54/lPzwKBgGbm92RfNanVkbeR/rVFErFu5D9Fzj4frTDZrNtzG9dxw4vml2Kj\nkWnOrML+EW8i6s8ckLBkjTXnEwoo09CcWT0LcVzpynqX1xAfRJdzIrIpPIqythHW\nfHjMWmq4PGVZ15uFTDJAc++wFn2/oWUvd7ulcN/ea6mBJaHSQbCFXi/bAoGBALu1\nvtjPShPlVXMP8kzRXpaZYXjPo59zv2n0te71eWlsNVhLgHsgMf8kBCJJR11ghgcl\nkfk2YAQRs/oD0bRwwPqnap+mQm2frN4LRtJ3WGfKKobB3G83ChdU0BWAkFCFOce/\nW0MjiOwT0mEYa0n6yRLpO1i4nyIZ0473wOKdZZVbAoGBAL4+ffKdzPJy4SG4v0L5\nPvYPW4u2gukA3G4aTWOg2EwUGq2HLaGFCvDqE+hR3bGqVEhk6X12vHuke4UFaN44\nXUfs8v65F/LT7VG0+dhfpDzbfhnVoTqsJOB3obQnQzJPfk4FThEQOBqepKV8PDyo\nVosJTLofmtwZH823UAZIIOd/\n-----END PRIVATE KEY-----\n",
                "client_email"=>"firebase-adminsdk-as4sm@copmoz-3x.iam.gserviceaccount.com",
                "client_id"=> "112030584520787629755",
                "auth_uri"=> "https://accounts.google.com/o/oauth2/auth",
                "token_uri"=> "https://oauth2.googleapis.com/token",
                "auth_provider_x509_cert_url"=> "https://www.googleapis.com/oauth2/v1/certs",
                "client_x509_cert_url"=> "https://www.googleapis.com/robot/v1/metadata/x509/firebase-adminsdk-as4sm%40copmoz-3x.iam.gserviceaccount.com",
                "universe_domain"=> "googleapis.com"
        ];
    
        $factory = (new Factory)->withServiceAccount($firebaseCredentials);
        $messaging = $factory->createMessaging();


        $token = $user->device_token;
            try {
                    if (strlen($token) >= 152) {
                        $notification = Notification::fromArray([
                            'token' => $token,
                            'title' => "hello",
                            'body' => "How are you",
                            'image' => null,
                        ]);
        
                        $message = CloudMessage::withTarget('token', $token)
                            ->withNotification($notification)
                            ->withHighestPossiblePriority()
                            ->withDefaultSounds();
                        $messaging->send($message);
                    } else {
                        Log::channel('log_notifications')->error("No token registered for user: {$user->name} - Token: ($user->device_token). Notification not sent.");
                    }
                } catch (NotFound $e) {
                        // Handle the 'NotFound' exception
                        Log::channel('log_notifications')->error("{$user->name} - Token not found: {$e->getMessage()}");
                } catch (\Exception $e) {
                // Handle all other exceptions
                echo 'An error occurred: ' . $e->getMessage();
                // Log the error, notify the user, or take appropriate action
            }

        // Return a response, for example
        return response()->json([
            'users' => "Hello",
        ], 201);
    }

    public function getChannelId(Request $request)
    {
		$user_id = $request['user_id'];
		$res = Chatify::getOrCreateChannel($user_id);
		
		// send the response
		return Response::json($res, 200);
    }


    public function pusherAuth(Request $request)
    {   

        $user = Auth::guard('api')->user();

    if (!$user) {
        return response()->json([
            'status' => '401',
            'message' => 'Unauthorized! Invalid token.'
        ], 401);
    } else {
        return Chatify::pusherAuth(
            $user,  // Pass the user based on the token
            $user,
            $request['channel_name'],
            $request['socket_id']
        );
    }

        //return Chatify::pusherAuth(
        //    $request->user(),
        //    auth('sanctum')->user(),
        //    $request['channel_name'],
        //    $request['socket_id']
        //);
    }

    /**
     * Fetch data by id for (user/group)
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function idFetchData(Request $request)
    {
        return auth()->user();
        // Favorite
        $favorite = Chatify::inFavorite($request['id']);

        // User data
        if ($request['type'] == 'user') {
            $fetch = User::where('id', $request['id'])->first();
            if($fetch){
                $userAvatar = Chatify::getUserWithAvatar($fetch)->avatar;
            }
        }

        // send the response
        return Response::json([
            'favorite' => $favorite,
            'fetch' => $fetch ?? null,
            'user_avatar' => $userAvatar ?? null,
        ]);
    }

    /**
     * This method to make a links for the attachments
     * to be downloadable.
     *
     * @param string $fileName
     * @return \Illuminate\Http\JsonResponse
     */
    public function download($fileName)
    {
        $path = config('chatify.attachments.folder') . '/' . $fileName;
        if (Chatify::storage()->exists($path)) {
            return response()->json([
                'file_name' => $fileName,
                'download_path' => Chatify::storage()->url($path)
            ], 200);
        } else {
            return response()->json([
                'message'=>"Sorry, File does not exist in our server or may have been deleted!"
            ], 404);
        }
    }

    /**
     * Send a message to database
     *
     * @param Request $request
     * @return JSON response
     */
    public function send(Request $request)
    {
        // default variables
        $error = (object)[
            'status' => 0,
            'message' => null
        ];
        $attachment = null;
        $attachment_title = null;

        // if there is attachment [file]
        if ($request->hasFile('file')) {
            // allowed extensions
            $allowed_images = Chatify::getAllowedImages();
            $allowed_files  = Chatify::getAllowedFiles();
            $allowed        = array_merge($allowed_images, $allowed_files);

            $file = $request->file('file');
            // check file size
            if ($file->getSize() < Chatify::getMaxUploadSize()) {
                if (in_array(strtolower($file->extension()), $allowed)) {
                    // get attachment name
                    $attachment_title = $file->getClientOriginalName();
                    // upload attachment and store the new name
                    $attachment = Str::uuid() . "." . $file->extension();
                    $file->storeAs(config('chatify.attachments.folder'), $attachment, config('chatify.storage_disk_name'));
                } else {
                    $error->status = 1;
                    $error->message = "File extension not allowed!";
                }
            } else {
                $error->status = 1;
                $error->message = "File size you are trying to upload is too large!";
            }
        }

        if (!$error->status) {
            // send to database
            $message = Chatify::newMessage([
                'type' => $request['type'],
                'from_id' => Auth::user()->id,
                'to_channel_id' => $request['channel_id'],
                'body' => htmlentities(trim($request['message']), ENT_QUOTES, 'UTF-8'),
                'attachment' => ($attachment) ? json_encode((object)[
                    'new_name' => $attachment,
                    'old_name' => htmlentities(trim($attachment_title), ENT_QUOTES, 'UTF-8'),
                ]) : null,
            ]);

            // fetch message to send it with the response
            $messageData = Chatify::parseMessage($message);

            // send to user using pusher
            //if (Auth::user()->id == $messageData["from_id"]) {
                
                Chatify::push("private-chatify.".$request['channel_id'], 'messaging', [
                    'from_id' => Auth::user()->id,
                    'to_id' => $request['channel_id'],
                    'message' => $messageData
                ]);

                //send notification
        $firebaseCredentials = [
            "type"=> "service_account",
            "project_id"=> "copmoz-3x",
            "private_key_id"=> "7768bcef3df838b966f6ec0f3fd398ced9336439",
            "private_key"=> "-----BEGIN PRIVATE KEY-----\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDY12nvQbs5PGiU\nuZrrhOKpCB5viTy6PdNNB0vz8MRA+8SL4RaZG8b/AA9qgNRj03GMx3cP6OVFMi7C\n7/KRjjHJisfK0etOqfRc8IVrG4pizwmetMLdE1PsSNsHaC/mddLQKbKwsf8QhJGb\npSRI4PMdgSGmsvpn0L0ki7DhrdRF7d8NdFFLdrXTtULSmpWyh+Mvt9GApM/ffQh6\nAC0X04BANj449xCAJVFsjfDrXgN4/ZOOBUItLZK0ICDjuaf8009ABdxn28Y0oRQC\nIk4fbPtBcLhofFyXiGDV0XiAvgCioyM4eTPDLfU3d9NbgF7pHo2aust4qg2qt5/k\ncVKN4TMhAgMBAAECggEAMOaXdcTpj3VPkmavCLkNkpgJoRaectO5gLAKEWe1IoCE\nqRToTzwD6wLc9yQ5gY+wFlLvR0+60JmKER0io2+hS7W368XeXn2WZZU6SVbLJRBS\nt49FOK0AqpMdjfSRhNQCaD5XFWD2yAdVfPfHkIXmXbt+1sSbEulwljrId4SHkAMz\n+epUKT48svL+Kbdijz9zZjzw1LkX768tn4G+7vDNv2VgQnZbWHun0beOHvYesb7A\ncHQqT20B8wHRlVzUV5Mj61Tzgn84Oq+7TFwFkw/kYu3ErtP+Cwv+LWExnyeZ2ZMe\nvGPQRvN9BRbr5gyIJzc0FX9jPzfI/7lbdePVdgHNTwKBgQD3i9aSfBO+SiMsh3y8\nsBkE8sG6bP/lXk9ySLEV/3LFB9sRJpFOe4hCOvFY2wb0pHbVZd65o2FdmvRZm5DK\nrJA8oqByOIt9x9dBMIEQW4IrNNOeJwEflpagL/32KH4L16PPcf3CYZRLQCxVRMlm\n+FTTtGDpydnA/e8YO8weGU2aDwKBgQDgPyP1QiIbvotj9V3hNXYfiT88m/Al9roe\nHkQ2psE3YCz4BQGQ8xfPYmY3dDyHFegPLHHDiHMkvPTcFxt0S9P7k/eKOLBpgp9e\nihrNoDXBD5B0wgLQc1Mp4HYEeTnH9mEKOGURznOIF8X4uVY7+WzV56Rb38NZHIi7\nf0J54/lPzwKBgGbm92RfNanVkbeR/rVFErFu5D9Fzj4frTDZrNtzG9dxw4vml2Kj\nkWnOrML+EW8i6s8ckLBkjTXnEwoo09CcWT0LcVzpynqX1xAfRJdzIrIpPIqythHW\nfHjMWmq4PGVZ15uFTDJAc++wFn2/oWUvd7ulcN/ea6mBJaHSQbCFXi/bAoGBALu1\nvtjPShPlVXMP8kzRXpaZYXjPo59zv2n0te71eWlsNVhLgHsgMf8kBCJJR11ghgcl\nkfk2YAQRs/oD0bRwwPqnap+mQm2frN4LRtJ3WGfKKobB3G83ChdU0BWAkFCFOce/\nW0MjiOwT0mEYa0n6yRLpO1i4nyIZ0473wOKdZZVbAoGBAL4+ffKdzPJy4SG4v0L5\nPvYPW4u2gukA3G4aTWOg2EwUGq2HLaGFCvDqE+hR3bGqVEhk6X12vHuke4UFaN44\nXUfs8v65F/LT7VG0+dhfpDzbfhnVoTqsJOB3obQnQzJPfk4FThEQOBqepKV8PDyo\nVosJTLofmtwZH823UAZIIOd/\n-----END PRIVATE KEY-----\n",
            "client_email"=>"firebase-adminsdk-as4sm@copmoz-3x.iam.gserviceaccount.com",
            "client_id"=> "112030584520787629755",
            "auth_uri"=> "https://accounts.google.com/o/oauth2/auth",
            "token_uri"=> "https://oauth2.googleapis.com/token",
            "auth_provider_x509_cert_url"=> "https://www.googleapis.com/oauth2/v1/certs",
            "client_x509_cert_url"=> "https://www.googleapis.com/robot/v1/metadata/x509/firebase-adminsdk-as4sm%40copmoz-3x.iam.gserviceaccount.com",
            "universe_domain"=> "googleapis.com"
        ];

        $factory = (new Factory)->withServiceAccount($firebaseCredentials);
        $messaging = $factory->createMessaging();

        $user = User::where('id', $request['userId'])->first();
        $token = $user->device_token;

        try {
            if (strlen($token) >= 152) {
                $notification = Notification::fromArray([
                    'token' => $token,
                    'title' => "New Message from ".Auth::user()->name,
                    'body' => ($attachment) ?"Attachment File":$message->body,
                    'image' => null,
                ]);
    
                $message = CloudMessage::withTarget('token', $token)
                    ->withNotification($notification)
                    ->withHighestPossiblePriority()
                    ->withDefaultSounds();
                $messaging->send($message);
            } else {
                Log::channel('log_notifications')->error("No token registered for user: {$user->name} - Token: ($user->device_token). Notification not sent.");
            }
        } catch (NotFound $e) {
                // Handle the 'NotFound' exception
                Log::channel('log_notifications')->error("{$user->name} - Token not found: {$e->getMessage()}");
        } catch (\Exception $e) {
            // Handle all other exceptions
            echo 'An error occurred: ' . $e->getMessage();
            // Log the error, notify the user, or take appropriate action
        }

               
            //}            
            
        }
            
            
        
            

        // send the response
        return Response::json([
            'status' => '200',
            'error' => $error,
            'message' => $messageData ?? [],
            'tempID' => $request['temporaryMsgId'],
            'token' => $user,
        ]);
    }

    /**
     * fetch [user/group] messages from database
     *
     * @param Request $request
     * @return JSON response
     */
    public function fetch(Request $request)
    {
        $query = Chatify::fetchMessagesQuery($request['id'])->latest();
        $messages = $query->paginate($request->per_page ?? $this->perPage);
        $totalMessages = $messages->total();
        $lastPage = $messages->lastPage();
        $response = [
            'total' => $totalMessages,
            'last_page' => $lastPage,
            'last_message_id' => collect($messages->items())->last()->id ?? null,
            'messages' => $messages->items(),
        ];
        return Response::json($response);
    }

    /**
     * Make messages as seen
     *
     * @param Request $request
     * @return void
     */
    public function seen(Request $request)
    {
        // make as seen
        $seen = Chatify::makeSeen($request['id']);
        // send the response
        return Response::json([
            'status' => $seen,
        ], 200);
    }

    /**
     * Get contacts list
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse response
     */
    public function getContacts(Request $request){
    // Get the token from the request header
    $user = Auth::guard('api')->user();

    if (!$user) {
        return response()->json([
            'status' => '401',
            'message' => 'Unauthorized! Invalid token.'
        ], 401);
    } else {
        
        //$query = Channel::join('ch_messages', 'ch_channels.id', '=', 'ch_messages.to_channel_id')
        //    ->join('ch_channel_user', 'ch_channels.id', '=', 'ch_channel_user.channel_id')
        //    ->where('ch_channel_user.user_id','=',Auth::user()->id)
        //    ->select('ch_channels.*', DB::raw('ch_messages.created_at messaged_at'))
        //    ->groupBy('ch_channels.id')
        //    ->orderBy('messaged_at', 'desc')
        //    ->paginate($request->per_page ?? $this->perPage);

        
        
            
      
        //$channelsList = $query->items();

        // Proceed with fetching contacts
        // $users = Message::join('users', function ($join) use ($user) {
        //         $join->on('ch_messages.from_id', '=', 'users.id')
        //              ->orWhere('ch_messages.to_id', '=', 'users.id');
        //     })
        //     ->where(function ($q) use ($user) {
        //         $q->where('ch_messages.from_id', $user->id)
        //           ->orWhere('ch_messages.to_id', $user->id);
        //     })
        //     ->where('users.id', '!=', $user->id)
        //     ->select('users.*', DB::raw('MAX(ch_messages.created_at) as max_created_at'))
        //     ->orderByDesc('max_created_at')
        //     ->groupBy('users.id')
        //     ->paginate($request->per_page ?? $this->perPage);

        $query = Channel::join('ch_messages', 'ch_channels.id', '=', 'ch_messages.to_channel_id')
            ->join('ch_channel_user', 'ch_channels.id', '=', 'ch_channel_user.channel_id')
            ->where('ch_channel_user.user_id','=',Auth::user()->id)
            ->select('ch_channels.*', DB::raw('ch_messages.created_at messaged_at'))
            ->groupBy('ch_channels.id')
            ->orderBy('messaged_at', 'desc')
            ->paginate($request->per_page ?? $this->perPage);

        $channelsList = $query->items();

        if (count($channelsList) > 0) {

            $users_list = [];
            foreach ($channelsList as $channel) {
                $lastMessage = Chatify::getLastMessageQuery($channel->id);
                $unseenCounter = Chatify::countUnseenMessages($channel->id);
                if ($lastMessage) {
                   $lastMessage->created_at = $lastMessage->created_at->toIso8601String();
                   $lastMessage->timeAgo = $lastMessage->created_at->diffForHumans();
                }

                // check if this channel is a group
            if (isset($channel->owner_id)) {
                $users_list[] = [
                    'get' => 'contact-group',
                    'channel' => Chatify::getChannelWithAvatar($channel),
                    'last_message' => $lastMessage,
                    'unseen_counter' => $unseenCounter,
                ];
                
            } else {
                $user = Chatify::getUserInOneChannel($channel->id);
                $users_list[] = [
                    'get' => 'contact-user',
                    'channel' => $channel,
                    'user' => Chatify::getUserWithAvatar($user),
                    'last_message' => $lastMessage,
                    'unseen_counter' => $unseenCounter,
                ];
            }

                //$users_list[] = [
                //  'user' => Chatify::getUserInOneChannel($channel->id),
                //  'last_message' => $lastMessage,
                //  'unseen_counter' => $unseenCounter,
                //];

            }
        } else {
            $contacts = '<p class="message-hint center-el"><span>Your contact list is empty</span></p>';
        }

        return response()->json([
            'contacts' => $users_list,
            'total' => $query->total() ?? 0,
            'last_page' => $query->lastPage() ?? 1,
        ], 200);
    }
    }
    // public function getContacts(Request $request)
    // {
    //     // Get the authenticated user
    // $token = $request->header('token');

    // if (empty($token)) {
    //     return response()->json([
    //         'status' => '401',
    //         'message' => 'Access Denied!'
    //     ], 401);
    // } else {
    //     // Find user based on the token
    //     $user = User::where('token', $token)->first();
    //     // Check if user is found
    //     if (!$user) {
    //         return response()->json([
    //             'status' => '401',
    //             'message' => 'Unauthorized! Invalid token.'
    //         ], 401);
    //     }

    //     // get all users that received/sent message from/to [Auth user]
    //     $users = Message::join('users',  function ($join) use ($user) {
    //         $join->on('ch_messages.from_id', '=', 'users.id')
    //             ->orOn('ch_messages.to_id', '=', 'users.id');
    //     })
    //     ->where(function ($q) {
    //         $q->where('ch_messages.from_id', $user->id)
    //         ->orWhere('ch_messages.to_id', $user->id);
    //     })
    //     ->where('users.id','!=',$user->id)
    //     ->select('users.*',DB::raw('MAX(ch_messages.created_at) max_created_at'))
    //     ->orderBy('max_created_at', 'desc')
    //     ->groupBy('users.id')
    //     ->paginate($request->per_page ?? $this->perPage);

    //     return response()->json([
    //         'contacts' => $users->items(),
    //         'total' => $users->total() ?? 0,
    //         'last_page' => $users->lastPage() ?? 1,
    //     ], 200);

    //   }
    // }

    /**
     * Put a user in the favorites list
     *
     * @param Request $request
     * @return void
     */
    public function favorite(Request $request)
    {
        $userId = $request['user_id'];
        // check action [star/unstar]
        $favoriteStatus = Chatify::inFavorite($userId) ? 0 : 1;
        Chatify::makeInFavorite($userId, $favoriteStatus);

        // send the response
        return Response::json([
            'status' => @$favoriteStatus,
        ], 200);
    }

    /**
     * Get favorites list
     *
     * @param Request $request
     * @return void
     */
    public function getFavorites(Request $request)
    {
        $favorites = Favorite::where('user_id', Auth::user()->id)->get();
        foreach ($favorites as $favorite) {
            $favorite->user = User::where('id', $favorite->favorite_id)->first();
        }
        return Response::json([
            'total' => count($favorites),
            'favorites' => $favorites ?? [],
        ], 200);
    }

    /**
     * Search in messenger
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function search(Request $request)
    {
        $input = trim(filter_var($request['input']));
        //$records = User::where('id','!=',Auth::user()->id)
        //            ->where('name', 'LIKE', "%{$input}%")
        //            ->paginate($request->per_page ?? $this->perPage);

        //foreach ($records->items() as $index => $record) {
        //    $records[$index] += Chatify::getUserWithAvatar($record);
        //}

        $records = User::select("id", "name", "avatar","active_status",  DB::raw("-1"))->where('id', '!=', Auth::user()->id)
            ->where('name', 'LIKE', "%{$input}%");
        $recordsteacher = Admin::select("id", "name", "avatar", "active_status", "role" )->where('id', '!=', Auth::user()->id)
            ->where('name', 'LIKE', "%{$input}%")
            ->union($records)
            ->paginate($request->per_page ?? $this->perPage);


        return Response::json([
            'records' => $recordsteacher->items(),
            'total' => $recordsteacher->total(),
            'last_page' => $recordsteacher->lastPage()
        ], 200);
    }

    /**
     * Get shared photos
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function sharedPhotos(Request $request)
    {
        $images = Chatify::getSharedPhotos($request['user_id']);

        foreach ($images as $image) {
            $image = asset(config('chatify.attachments.folder') . $image);
        }
        // send the response
        return Response::json([
            'shared' => $images ?? [],
        ], 200);
    }

    /**
     * Delete conversation
     *
     * @param Request $request
     * @return void
     */
    public function deleteConversation(Request $request)
    {
        // delete
        $delete = Chatify::deleteConversation($request['channel_id']);

        // send the response
        return Response::json([
            'deleted' => $delete ? 1 : 0,
        ], 200);
    }

    /**
     * Delete message
     *
     * @param Request $request
     * @return JsonResponse
     */


    public function deleteMessage(Request $request)
    {
        // delete
        $delete = Chatify::deleteMessage($request['id']);

        // send the response
        return Response::json([
            'deleted' => $delete ? 1 : 0,
        ], 200);
    }

    public function updateSettings(Request $request)
    {
        $msg = null;
        $error = $success = 0;

        // dark mode
        if ($request['dark_mode']) {
            $request['dark_mode'] == "dark"
                ? User::where('id', Auth::user()->id)->update(['dark_mode' => 1])  // Make Dark
                : User::where('id', Auth::user()->id)->update(['dark_mode' => 0]); // Make Light
        }

        // If messenger color selected
        if ($request['messengerColor']) {
            $messenger_color = trim(filter_var($request['messengerColor']));
            User::where('id', Auth::user()->id)
                ->update(['messenger_color' => $messenger_color]);
        }
        // if there is a [file]
        if ($request->hasFile('avatar')) {
            // allowed extensions
            $allowed_images = Chatify::getAllowedImages();

            $file = $request->file('avatar');
            // check file size
            if ($file->getSize() < Chatify::getMaxUploadSize()) {
                if (in_array(strtolower($file->extension()), $allowed_images)) {
                    // delete the older one
                    if (Auth::user()->avatar != config('chatify.user_avatar.default')) {
                        $path = Chatify::getUserAvatarUrl(Auth::user()->avatar);
                        if (Chatify::storage()->exists($path)) {
                            Chatify::storage()->delete($path);
                        }
                    }
                    // upload
                    $avatar = Str::uuid() . "." . $file->extension();
                    $update = User::where('id', Auth::user()->id)->update(['avatar' => $avatar]);
                    $file->storeAs(config('chatify.user_avatar.folder'), $avatar, config('chatify.storage_disk_name'));
                    $success = $update ? 1 : 0;
                } else {
                    $msg = "File extension not allowed!";
                    $error = 1;
                }
            } else {
                $msg = "File size you are trying to upload is too large!";
                $error = 1;
            }
        }

        // send the response
        return Response::json([
            'status' => $success ? 1 : 0,
            'error' => $error ? 1 : 0,
            'message' => $error ? $msg : 0,
        ], 200);
    }

    /**
     * Set user's active status
     *
     * @param Request $request
     * @return void
     */
    public function setActiveStatus(Request $request)
    {
        $activeStatus = $request['status'] > 0 ? 1 : 0;
        $status = User::where('id', Auth::user()->id)->update(['active_status' => $activeStatus]);
        return Response::json([
            'status' => $status,
        ], 200);
    }
}
