<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;

class FeePaymentsTemplateExport implements FromArray, WithHeadings, WithStyles, WithColumnWidths
{
    public function array(): array
    {
        return [
            ['1234567', '01', '2025', '2500.00', '15/01/2025', 'Cash', 'Pago na secretaria'],
            ['7654321', '02', '2025', '3000.00', '20/02/2025', 'Bank', 'Transferência bancária'],
            ['9876543', '01', '2026', '2500.00', '10/01/2026', 'Mobile', 'Pagamento M-Pesa'],
        ];
    }

    public function headings(): array
    {
        return [
            'Número Aluno',
            'Mês (01-12)',
            'Ano',
            'Valor (MT)',
            'Data Pagamento (dd/mm/aaaa)',
            'Modo Pagamento',
            'Observação',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => [
                'font' => [
                    'bold' => true,
                    'size' => 12,
                    'color' => ['rgb' => 'FFFFFF']
                ],
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => '4472C4']
                ],
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => ['rgb' => '000000']
                    ]
                ]
            ],
            'A2:G4' => [
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'E7E6E6']
                ],
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => ['rgb' => 'CCCCCC']
                    ]
                ]
            ],
        ];
    }

    public function columnWidths(): array
    {
        return [
            'A' => 18,
            'B' => 14,
            'C' => 10,
            'D' => 15,
            'E' => 28,
            'F' => 20,
            'G' => 30,
        ];
    }
}
