<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\MatrizesExport;
use App\Exports\ComunicadosExport;
use App\Exports\EstudantesExport;
use App\Exports\ProfessoresExport;
use Barryvdh\DomPDF\Facade\Pdf;

class ExportController extends Controller
{
    // Matrizes
    public function matrizesExcel(Request $request)
    {
        $filters = [
            'class' => $request->get('class'),
            'turma' => $request->get('turma'),
            'search' => $request->get('search'),
            'filter' => $request->get('filter'),
        ];

        return Excel::download(new MatrizesExport($filters), 'matrizes_' . date('Y-m-d_H-i-s') . '.xlsx');
    }

    public function matrizesPDF(Request $request)
    {
        $filters = [
            'class' => $request->get('class'),
            'turma' => $request->get('turma'),
            'search' => $request->get('search'),
            'filter' => $request->get('filter'),
        ];

        $export = new MatrizesExport($filters);
        $data = $export->collection();

        $pdf = Pdf::loadView('exports.matrizes-pdf', [
            'matrizes' => $data,
            'headings' => $export->headings()
        ]);

        return $pdf->download('matrizes_' . date('Y-m-d_H-i-s') . '.pdf');
    }

    // Comunicados
    public function comunicadosExcel(Request $request)
    {
        $filters = [
            'type' => $request->get('type'),
            'class' => $request->get('class'),
            'turma' => $request->get('turma'),
            'search' => $request->get('search'),
        ];

        return Excel::download(new ComunicadosExport($filters), 'comunicados_' . date('Y-m-d_H-i-s') . '.xlsx');
    }

    public function comunicadosPDF(Request $request)
    {
        $filters = [
            'type' => $request->get('type'),
            'class' => $request->get('class'),
            'turma' => $request->get('turma'),
            'search' => $request->get('search'),
        ];

        $export = new ComunicadosExport($filters);
        $data = $export->collection();

        $pdf = Pdf::loadView('exports.comunicados-pdf', [
            'comunicados' => $data,
            'headings' => $export->headings()
        ]);

        return $pdf->download('comunicados_' . date('Y-m-d_H-i-s') . '.pdf');
    }

    // Estudantes
    public function estudantesExcel(Request $request)
    {
        $filters = [
            'class' => $request->get('class'),
            'turma' => $request->get('turma'),
            'status' => $request->get('status'),
            'payment' => $request->get('payment'),
            'search' => $request->get('search'),
        ];

        return Excel::download(new EstudantesExport($filters), 'estudantes_' . date('Y-m-d_H-i-s') . '.xlsx');
    }

    public function estudantesPDF(Request $request)
    {
        $filters = [
            'class' => $request->get('class'),
            'turma' => $request->get('turma'),
            'status' => $request->get('status'),
            'payment' => $request->get('payment'),
            'search' => $request->get('search'),
        ];

        $export = new EstudantesExport($filters);
        $data = $export->collection();

        $pdf = Pdf::loadView('exports.estudantes-pdf', [
            'estudantes' => $data,
            'headings' => $export->headings()
        ]);

        return $pdf->download('estudantes_' . date('Y-m-d_H-i-s') . '.pdf');
    }

    // Professores
    public function professoresExcel(Request $request)
    {
        $filters = [
            'class' => $request->get('class'),
            'turma' => $request->get('turma'),
            'subject' => $request->get('subject'),
            'status' => $request->get('status'),
            'search' => $request->get('search'),
        ];

        return Excel::download(new ProfessoresExport($filters), 'professores_' . date('Y-m-d_H-i-s') . '.xlsx');
    }

    public function professoresPDF(Request $request)
    {
        $filters = [
            'class' => $request->get('class'),
            'turma' => $request->get('turma'),
            'subject' => $request->get('subject'),
            'status' => $request->get('status'),
            'search' => $request->get('search'),
        ];

        $export = new ProfessoresExport($filters);
        $data = $export->collection();

        $pdf = Pdf::loadView('exports.professores-pdf', [
            'professores' => $data,
            'headings' => $export->headings()
        ]);

        return $pdf->download('professores_' . date('Y-m-d_H-i-s') . '.pdf');
    }

    // Turmas
    public function turmasExcel(Request $request)
    {
        $filters = [
            'class' => $request->get('class'),
            'status' => $request->get('status'),
            'search' => $request->get('search'),
        ];

        return Excel::download(new \App\Exports\TurmasExport($filters), 'turmas_' . date('Y-m-d_H-i-s') . '.xlsx');
    }

    public function turmasPDF(Request $request)
    {
        $filters = [
            'class' => $request->get('class'),
            'status' => $request->get('status'),
            'search' => $request->get('search'),
        ];

        $export = new \App\Exports\TurmasExport($filters);
        $data = $export->collection();

        $pdf = Pdf::loadView('exports.turmas-pdf', [
            'turmas' => $data,
            'headings' => $export->headings()
        ]);

        return $pdf->download('turmas_' . date('Y-m-d_H-i-s') . '.pdf');
    }

    // Disciplinas
    public function disciplinasExcel(Request $request)
    {
        $filters = [
            'search' => $request->get('search'),
        ];

        return Excel::download(new \App\Exports\DisciplinasExport($filters), 'disciplinas_' . date('Y-m-d_H-i-s') . '.xlsx');
    }

    public function disciplinasPDF(Request $request)
    {
        $filters = [
            'search' => $request->get('search'),
        ];

        $export = new \App\Exports\DisciplinasExport($filters);
        $data = $export->collection();

        $pdf = Pdf::loadView('exports.disciplinas-pdf', [
            'disciplinas' => $data,
            'headings' => $export->headings()
        ]);

        return $pdf->download('disciplinas_' . date('Y-m-d_H-i-s') . '.pdf');
    }

    // Staff
    public function staffExcel(Request $request)
    {
        $filters = [
            'role' => $request->get('role'),
            'status' => $request->get('status'),
            'search' => $request->get('search'),
        ];

        return Excel::download(new \App\Exports\StaffExport($filters), 'staff_' . date('Y-m-d_H-i-s') . '.xlsx');
    }

    public function staffPDF(Request $request)
    {
        $filters = [
            'role' => $request->get('role'),
            'status' => $request->get('status'),
            'search' => $request->get('search'),
        ];

        $export = new \App\Exports\StaffExport($filters);
        $data = $export->collection();

        $pdf = Pdf::loadView('exports.staff-pdf', [
            'staff' => $data,
            'headings' => $export->headings()
        ]);

        return $pdf->download('staff_' . date('Y-m-d_H-i-s') . '.pdf');
    }

    // SMS
    public function smsExcel(Request $request)
    {
        $filters = [
            'type' => $request->get('type'),
            'class' => $request->get('class'),
            'search' => $request->get('search'),
        ];

        return Excel::download(new \App\Exports\SmsExport($filters), 'sms_' . date('Y-m-d_H-i-s') . '.xlsx');
    }

    public function smsPDF(Request $request)
    {
        $filters = [
            'type' => $request->get('type'),
            'class' => $request->get('class'),
            'search' => $request->get('search'),
        ];

        $export = new \App\Exports\SmsExport($filters);
        $data = $export->collection();

        $pdf = Pdf::loadView('exports.sms-pdf', [
            'sms' => $data,
            'headings' => $export->headings()
        ]);

        return $pdf->download('sms_' . date('Y-m-d_H-i-s') . '.pdf');
    }

    // Paid Students (Regulares)
    public function paidStudentsExcel(Request $request)
    {
        $filters = [
            'class' => $request->get('class'),
            'turma' => $request->get('turma'),
            'search' => $request->get('search'),
        ];

        return Excel::download(new \App\Exports\PaidStudentsExport($filters), 'estudantes_regulares_' . date('Y-m-d_H-i-s') . '.xlsx');
    }

    public function paidStudentsPDF(Request $request)
    {
        $filters = [
            'class' => $request->get('class'),
            'turma' => $request->get('turma'),
            'search' => $request->get('search'),
        ];

        $export = new \App\Exports\PaidStudentsExport($filters);
        $data = $export->collection();

        $pdf = Pdf::loadView('exports.paid-students-pdf', [
            'students' => $data,
            'headings' => $export->headings()
        ]);

        return $pdf->download('estudantes_regulares_' . date('Y-m-d_H-i-s') . '.pdf');
    }

    // Unpaid Students (Irregulares)
    public function unpaidStudentsExcel(Request $request)
    {
        $filters = [
            'class' => $request->get('class'),
            'turma' => $request->get('turma'),
            'search' => $request->get('search'),
        ];

        return Excel::download(new \App\Exports\UnpaidStudentsExport($filters), 'estudantes_irregulares_' . date('Y-m-d_H-i-s') . '.xlsx');
    }

    public function unpaidStudentsPDF(Request $request)
    {
        $filters = [
            'class' => $request->get('class'),
            'turma' => $request->get('turma'),
            'search' => $request->get('search'),
        ];

        $export = new \App\Exports\UnpaidStudentsExport($filters);
        $data = $export->collection();

        $pdf = Pdf::loadView('exports.unpaid-students-pdf', [
            'students' => $data,
            'headings' => $export->headings()
        ]);

        return $pdf->download('estudantes_irregulares_' . date('Y-m-d_H-i-s') . '.pdf');
    }

    // Payment Reports
    public function paymentReportsExcel(Request $request)
    {
        $data = $this->getPaymentReportsData($request);

        return Excel::download(
            new \App\Exports\PaymentReportsExport(
                $data['payments'],
                $data['filters'],
                $data['totalAmount'],
                $data['totalCount'],
                $data['totalFine'],
                $data['subtotal']
            ),
            'relatorio-pagamentos-' . now()->format('Y-m-d-His') . '.xlsx'
        );
    }

    public function paymentReportsPDF(Request $request)
    {
        $data = $this->getPaymentReportsData($request);

        $pdf = Pdf::loadView('livewire.admin.reports.payment-reports-pdf', $data);
        $pdf->setPaper('A4', 'landscape');

        return $pdf->download('relatorio-pagamentos-' . now()->format('Y-m-d-His') . '.pdf');
    }

    private function getPaymentReportsData(Request $request)
    {
        $filter_type = $request->get('filter_type');
        $class_id = $request->get('class_id');
        $student_id = $request->get('student_id');
        $reference_number = $request->get('reference_number');
        $transaction_id = $request->get('transaction_id');
        $date_from = $request->get('date_from');
        $date_to = $request->get('date_to');
        $payment_status = $request->get('payment_status');

        $query = \App\Models\Fee_assign::query()
            ->with(['student', 'student.classroom', 'paymentReference'])
            ->whereBetween('payment_date', [
                \Carbon\Carbon::parse($date_from)->startOfDay(),
                \Carbon\Carbon::parse($date_to)->endOfDay()
            ]);

        // Aplicar filtros
        if ($filter_type === 'class' && $class_id) {
            $query->whereHas('student', function ($q) use ($class_id) {
                $q->where('classroom_id', $class_id);
            });
        } elseif ($filter_type === 'reference' && $reference_number) {
            $query->whereHas('paymentReference', function ($q) use ($reference_number) {
                $q->where('reference_number', $reference_number);
            });
        } elseif ($filter_type === 'transaction' && $transaction_id) {
            // Buscar por POS Transaction ID
            $query->where('transaction_id', $transaction_id);
        } elseif ($filter_type === 'student' && $student_id) {
            $query->where('student_id', $student_id);
        }

        if ($payment_status === 'paid') {
            $query->whereNotNull('amount')->where('amount', '>', 0);
        } elseif ($payment_status === 'pending') {
            $query->where(function ($q) {
                $q->whereNull('amount')->orWhere('amount', '=', 0);
            });
        }

        $payments = $query->orderBy('payment_date', 'desc')->get();

        // Calcular totais
        // Fórmula: VALOR BASE + MULTA - DESCONTO = TOTAL
        $subtotal = $payments->sum('amount') ?? 0; // Valor base (sem multa)
        $totalFine = $payments->sum('fine') ?? 0; // Multa total
        $totalDiscount = $payments->sum('discount') ?? 0; // Desconto total
        $totalAmount = $subtotal + $totalFine - $totalDiscount; // Total final
        $totalCount = $payments->count() ?? 0;

        // Criar resumo dos filtros
        $filters = [];
        $filters[] = 'Período: ' . \Carbon\Carbon::parse($date_from)->format('d/m/Y') . ' até ' . \Carbon\Carbon::parse($date_to)->format('d/m/Y');

        if ($filter_type === 'class' && $class_id) {
            $classroom = \App\Models\Classroom::find($class_id);
            if ($classroom) {
                $filters[] = 'Turma: ' . $classroom->class . ' - ' . $classroom->name;
            }
        } elseif ($filter_type === 'student' && $student_id) {
            $student = \App\Models\Student::find($student_id);
            if ($student) {
                $filters[] = 'Estudante: ' . $student->name;
            }
        } elseif ($filter_type === 'reference' && $reference_number) {
            $filters[] = 'Referência: ' . $reference_number;
        }

        if ($payment_status) {
            $filters[] = 'Estado: ' . ($payment_status === 'paid' ? 'Pago' : 'Pendente');
        }

        return [
            'payments' => $payments,
            'filters' => $filters,
            'totalAmount' => $totalAmount,
            'totalFine' => $totalFine,
            'subtotal' => $subtotal,
            'totalCount' => $totalCount,
            'results' => $payments,
            'total_amount' => $totalAmount,
            'total_fine' => $totalFine,
            'total_count' => $totalCount,
        ];
    }
}
