<?php

namespace App\Http\Livewire\Admin\POS;

use App\Models\POS\Sale;
use App\Models\POS\Setting;
use Barryvdh\DomPDF\Facade\Pdf;
use Livewire\Component;

class SaleReceipt extends Component
{
    public $sale;
    public $store_name;
    public $receipt_footer;

    public function mount($saleId)
    {
        $this->sale = Sale::with(['user', 'cashier', 'items.product'])
            ->findOrFail($saleId);

        $this->store_name = Setting::get('store_name', 'COPMOZ Store');
        $this->receipt_footer = Setting::get('receipt_footer', 'Obrigado pela sua compra!');
    }

    public function print()
    {
        $this->dispatchBrowserEvent('print-receipt');
    }

    public function downloadPDF()
    {
        $format = Setting::get('receipt_format', 'a4');

        $pdf = Pdf::loadView('livewire.admin.pos.sale-receipt-pdf', [
            'sale' => $this->sale,
            'store_name' => $this->store_name,
            'receipt_footer' => $this->receipt_footer,
            'format' => $format,
        ]);

        // Set paper size and options based on format
        if ($format === '80mm') {
            // 80mm width thermal printer (80mm = 226.77pt, auto height)
            $pdf->setPaper([0, 0, 226.77, 3000], 'portrait');
        } else {
            // A4 format (default)
            $pdf->setPaper('a4', 'portrait');
        }

        // Set DomPDF options for better rendering
        $pdf->setOptions([
            'isRemoteEnabled' => false,
            'isHtml5ParserEnabled' => true,
            'isFontSubsettingEnabled' => true,
        ]);

        return response()->streamDownload(function() use ($pdf) {
            echo $pdf->output();
        }, "recibo-{$this->sale->sale_number}.pdf");
    }

    public function render()
    {
        return view('livewire.admin.pos.sale-receipt');
    }
}
