<?php

namespace App\Http\Livewire\Guardian;

use App\Models\Guardian;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class Dashboard extends Component
{
    public function getGuardianProperty(): ?Guardian
    {
        return Auth::guard('guardian')->user();
    }

    public function getStudentsProperty()
    {
        return $this->guardian
            ? $this->guardian->students()->with('classroom')->get()
            : collect([]);
    }

    public function render()
    {
        return view('livewire.guardian.dashboard', [
            'students' => $this->students,
        ])->layout('layouts.app');
    }
}
