<?php

namespace App\Http\Livewire\Guardian;

use App\Models\Fee_assign;
use App\Models\Guardian;
use App\Models\Noticeboard;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Livewire\Component;

class Estudante extends Component
{
    public $studentId;

    public function mount(string $id)
    {
        $guardian = Auth::guard('guardian')->user();
        if (!$guardian || !$guardian->hasStudent($id)) {
            return redirect()->route('guardian.dashboard');
        }

        $this->studentId = $id;
        Session::put('guardian_student_id', $id);
    }

    public function getGuardianProperty(): ?Guardian
    {
        return Auth::guard('guardian')->user();
    }

    public function getStudentProperty(): ?User
    {
        return $this->guardian?->students()->with('classroom')->find($this->studentId);
    }

    public function getTotalPaidProperty(): float
    {
        if (!$this->student) return 0;
        return Fee_assign::where('student_id', $this->student->id)
            ->whereNotNull('amount')->where('amount', '>', 0)
            ->get()->sum(fn($p) => ($p->amount ?? 0) + ($p->fine ?? 0) - ($p->discount ?? 0));
    }

    public function getPaidCountProperty(): int
    {
        if (!$this->student) return 0;
        return Fee_assign::where('student_id', $this->student->id)->where('amount', '>', 0)->count();
    }

    public function getPendingCountProperty(): int
    {
        if (!$this->student) return 0;
        return Fee_assign::where('student_id', $this->student->id)
            ->where(fn($q) => $q->whereNull('amount')->orWhere('amount', 0))->count();
    }

    public function getRecentNoticesProperty()
    {
        return Noticeboard::where('status', 'active')
            ->where(fn($q) => $q->whereNull('class_id')
                ->orWhere('class_id', $this->student?->classroom_id)
                ->orWhere('student_id', $this->student?->id))
            ->latest()->limit(3)->get();
    }

    public function render()
    {
        return view('livewire.guardian.estudante', [
            'student'        => $this->student,
            'total_paid'     => $this->total_paid,
            'paid_count'     => $this->paid_count,
            'pending_count'  => $this->pending_count,
            'recent_notices' => $this->recent_notices,
        ])->layout('layouts.app');
    }
}
