<?php

namespace App\Http\Livewire\User\Inc;

use Illuminate\Support\Facades\Auth;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;

class Header extends Component
{

    use FindGuard, LivewireAlert;

    public $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = ['noteAdded' => 'incrementNoteCount'];

    public function incrementNoteCount()
    {
        $this->loadData();
    }

    public function markAsRead()
    {
        if (!Auth::guard('web')->check()) {
            return;
        }

        foreach (Note::unreadNotifications(false) as $notification) {
            $notification->status = true;
            $notification->forceDelete();
        }

        $this->loadData();
        $this->alert('success', 'Todas as notificações marcadas como lidas...');
    }

    public function logout()
    {
        $guard = $this->findGuardType();
        if ($guard) {
            $guard->logout();
        }
        return redirect()->route('login');
    }

    public function render()
    {
        $user = Auth::guard('web')->user();

        return view('livewire.user.inc.header', [
            'notifications' => ($this->readyToLoad && $user)
                ? Note::unreadNotifications(false)
                : [],
            'user' => $user
        ]);
    }
}
