<?php

namespace App\Mail;

use App\Models\PaymentReference;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class PaymentReferenceCreated extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * The payment reference instance.
     */
    public $reference;

    /**
     * Total number of references created (for bulk operations)
     */
    public $totalCount;

    /**
     * Create a new message instance.
     */
    public function __construct(PaymentReference $reference, $totalCount = 1)
    {
        $this->reference = $reference;
        $this->totalCount = $totalCount;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        $subject = $this->totalCount > 1
            ? "COPMOZ - {$this->totalCount} Novas Referências Pendentes de Aprovação"
            : "COPMOZ - Nova Referência Pendente de Aprovação";

        return new Envelope(
            subject: $subject,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.payment-reference-created',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
