<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Attendance extends Model
{
    use HasFactory, Uuids, SoftDeletes;

    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'student_id',
        'classroom_id',
        'recorded_by',
        'date',
        'subject',
        'status',
        'observation',
        'year',
    ];

    protected $casts = [
        'date' => 'date',
    ];

    const STATUS_PRESENT   = 'present';
    const STATUS_ABSENT    = 'absent';
    const STATUS_LATE      = 'late';
    const STATUS_JUSTIFIED = 'justified';

    public static function statuses(): array
    {
        return [
            self::STATUS_PRESENT   => 'Presente',
            self::STATUS_ABSENT    => 'Ausente',
            self::STATUS_LATE      => 'Atrasado',
            self::STATUS_JUSTIFIED => 'Justificado',
        ];
    }

    public function student(): BelongsTo
    {
        return $this->belongsTo(User::class, 'student_id');
    }

    public function classroom(): BelongsTo
    {
        return $this->belongsTo(Classroom::class, 'classroom_id');
    }

    public function recorder(): BelongsTo
    {
        return $this->belongsTo(Admin::class, 'recorded_by');
    }

    public function scopeYear($query, $year)
    {
        return $query->where('year', $year);
    }

    public function scopeCurrentYear($query)
    {
        return $query->where('year', date('Y'));
    }

    public function scopeForClassroom($query, $classroomId)
    {
        return $query->where('classroom_id', $classroomId);
    }

    public function scopeForDate($query, $date)
    {
        return $query->where('date', $date);
    }
}
