<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FeeGroup extends Model
{
    use HasFactory;

    protected $table = 'fee_group';

    protected $fillable = [
        'name',
        'description',
        'amount',
        'default_description',
        'parent_id',
        'fine_type',
        'percentage',
        'fixed_amount',
        'grace_days',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    /**
     * Get the fee masters associated with this fee group
     */
    public function feeMasters()
    {
        return $this->hasMany(FeeMaster1::class, 'fee_group_id');
    }

    /**
     * Get the parent category
     */
    public function parent()
    {
        return $this->belongsTo(FeeGroup::class, 'parent_id');
    }

    /**
     * Get subcategories
     */
    public function children()
    {
        return $this->hasMany(FeeGroup::class, 'parent_id');
    }

    /**
     * Scope to get only root categories (no parent)
     */
    public function scopeRoots($query)
    {
        return $query->whereNull('parent_id');
    }
}
