<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentReminderSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'days_before',
        'message_template',
        'enabled',
        'priority',
    ];

    protected $casts = [
        'days_before' => 'integer',
        'enabled' => 'boolean',
        'priority' => 'integer',
    ];

    /**
     * Scope para apenas lembretes ativos
     */
    public function scopeEnabled($query)
    {
        return $query->where('enabled', true);
    }

    /**
     * Scope para ordenar por prioridade
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('priority');
    }

    /**
     * Processa o template da mensagem substituindo as variáveis
     */
    public function processTemplate(array $data): string
    {
        $message = $this->message_template;

        foreach ($data as $key => $value) {
            $message = str_replace('{' . $key . '}', $value, $message);
        }

        return $message;
    }

    /**
     * Retorna as variáveis disponíveis para usar nos templates
     */
    public static function getAvailableVariables(): array
    {
        return [
            'student_name' => 'Nome do estudante',
            'fee_month' => 'Mês da taxa',
            'fee_year' => 'Ano da taxa',
            'entity_code' => 'Código da entidade',
            'reference_number' => 'Número da referência',
            'amount' => 'Valor',
            'due_date' => 'Data de vencimento',
            'days_left' => 'Dias restantes',
        ];
    }
}
