<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
class ReadingStatus extends Model
{
    use HasFactory, Uuids, SoftDeletes;

    /**
     * stop the auto increment
     */
    public $incrementing = false;

    /**
     * type of auto-increment
     *
     * @string
     */
    protected $keyType = 'string';

    protected $fillable = [
        'book_id',
        'user_id',
        'book_title_id',
        ];

    public function book(): BelongsTo
    {
        return $this->belongsTo(Book::class, 'book_id')->latest();
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }


}
