<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class JsonEncodingServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Set default JSON encoding options to handle invalid UTF-8
        \Illuminate\Http\JsonResponse::macro('setEncodingOptions', function () {
            $this->encodingOptions = JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_SUBSTITUTE;
            return $this;
        });
    }
}
