-- Criar tabela receipt_numbers para numeração sequencial de recibos

CREATE TABLE IF NOT EXISTS `receipt_numbers` (
    `id` BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `receipt_type` VARCHAR(20) NOT NULL COMMENT 'fee_assign ou payment_reference',
    `record_id` BIGINT UNSIGNED NOT NULL COMMENT 'ID do registro original',
    `receipt_number` VARCHAR(20) NOT NULL UNIQUE COMMENT 'Número do recibo (ex: 000001/2025)',
    `issued_at` TIMESTAMP NOT NULL COMMENT 'Data de emissão do recibo',
    `issued_by` VARCHAR(50) NOT NULL COMMENT 'admin ou student',
    `user_id` BIGINT UNSIGNED NULL COMMENT 'ID do usuário que gerou',
    `created_at` TIMESTAMP NULL DEFAULT NULL,
    `updated_at` TIMESTAMP NULL DEFAULT NULL,

    INDEX `idx_receipt_type_record_id` (`receipt_type`, `record_id`),
    INDEX `idx_issued_at` (`issued_at`),
    INDEX `idx_issued_by` (`issued_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
