<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('pos_products', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('category_id');
            $table->string('name');
            $table->string('sku')->unique();
            $table->text('description')->nullable();
            $table->string('image')->nullable();

            // Pricing
            $table->decimal('cost_price', 10, 2)->default(0); // Preço de custo
            $table->decimal('selling_price', 10, 2); // Preço de venda
            $table->decimal('discount_price', 10, 2)->nullable(); // Preço com desconto

            // Stock
            $table->integer('quantity')->default(0);
            $table->integer('min_stock')->default(5); // Alerta de stock baixo
            $table->string('unit')->default('Unidade'); // Unidade, Kg, Litro, etc

            // Variants (para uniformes: tamanho)
            $table->string('variant_type')->nullable(); // Size, Color, etc
            $table->json('variant_options')->nullable(); // ["P", "M", "G", "GG"]

            // Additional
            $table->boolean('is_active')->default(true);
            $table->boolean('track_stock')->default(true);
            $table->text('notes')->nullable();

            $table->timestamps();
            $table->softDeletes();

            $table->foreign('category_id')->references('id')->on('pos_categories')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('pos_products');
    }
};
