<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Primeiro, remover duplicatas existentes (manter apenas a mais recente)
        DB::statement("
            DELETE fs1 FROM fee_structures fs1
            INNER JOIN fee_structures fs2
            WHERE fs1.grade = fs2.grade
                AND fs1.academic_year = fs2.academic_year
                AND fs1.fee_name = fs2.fee_name
                AND fs1.active = fs2.active
                AND fs1.active = 1
                AND fs1.id < fs2.id
        ");

        Schema::table('fee_structures', function (Blueprint $table) {
            // Índice único para prevenir estruturas de taxa duplicadas
            $table->unique(
                ['grade', 'academic_year', 'fee_name', 'active'],
                'unique_active_fee_structure'
            );

            // Índices para performance
            $table->index('grade', 'idx_fee_structures_grade');
            $table->index('academic_year', 'idx_fee_structures_academic_year');
            $table->index('active', 'idx_fee_structures_active');

            // Índice composto para queries comuns
            $table->index(['grade', 'active'], 'idx_fee_structures_grade_active');
            $table->index(['academic_year', 'active'], 'idx_fee_structures_year_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('fee_structures', function (Blueprint $table) {
            $table->dropUnique('unique_active_fee_structure');
            $table->dropIndex('idx_fee_structures_grade');
            $table->dropIndex('idx_fee_structures_academic_year');
            $table->dropIndex('idx_fee_structures_active');
            $table->dropIndex('idx_fee_structures_grade_active');
            $table->dropIndex('idx_fee_structures_year_active');
        });
    }
};
