<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('exam_configurations', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('subject_id');
            $table->integer('class_level')->comment('Classe: 1 a 12');
            $table->enum('exam_type', ['NE', 'AF', 'none'])->default('none')
                  ->comment('Tipo de avaliação: NE (Nota de Exame), AF (Avaliação Final) ou none (sem exame)');
            $table->boolean('is_active')->default(true);
            $table->integer('academic_year')->nullable()->comment('Ano letivo (opcional)');
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Índices
            $table->index('class_level');
            $table->index('exam_type');
            $table->index('is_active');
            $table->index('academic_year');

            // Chave única: uma configuração por disciplina/classe/ano
            $table->unique(['subject_id', 'class_level', 'academic_year'], 'unique_exam_config');

            // Foreign keys - Removidas temporariamente devido a possíveis problemas de constraint
            // As foreign keys podem ser adicionadas posteriormente se necessário
            // $table->foreign('subject_id')->references('id')->on('subjects')->onDelete('cascade');
            // $table->foreign('created_by')->references('id')->on('admins')->onDelete('set null');
            // $table->foreign('updated_by')->references('id')->on('admins')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('exam_configurations');
    }
};
