<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Primeiro, limpar valores inválidos (0)
        DB::table('payment_references')
            ->where('approved_by', 0)
            ->update(['approved_by' => null]);

        Schema::table('payment_references', function (Blueprint $table) {
            // Alterar coluna para char(36) para suportar UUIDs
            $table->char('approved_by', 36)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payment_references', function (Blueprint $table) {
            $table->unsignedBigInteger('approved_by')->nullable()->change();
        });
    }
};
