<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('certificate_batches', function (Blueprint $table) {
            $table->uuid('id')->primary();

            // Batch identification
            $table->string('batch_number')->unique();
            $table->string('description')->nullable();

            // Filtering criteria used
            $table->uuid('classroom_id')->nullable();
            $table->foreign('classroom_id')->references('id')->on('classrooms')->nullOnDelete();
            $table->integer('academic_year');

            // Progress tracking
            $table->enum('status', ['pending', 'processing', 'completed', 'failed'])->default('pending');
            $table->integer('total_students')->default(0);
            $table->integer('processed_count')->default(0);
            $table->integer('success_count')->default(0);
            $table->integer('failed_count')->default(0);
            $table->json('failed_students')->nullable();

            // ZIP file for batch download
            $table->string('zip_path')->nullable();
            $table->timestamp('zip_generated_at')->nullable();

            // Audit
            $table->uuid('created_by');
            $table->foreign('created_by')->references('id')->on('admins');

            $table->softDeletes();
            $table->timestamps();

            // Indexes
            $table->index(['academic_year', 'status']);
            $table->index('batch_number');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('certificate_batches');
    }
};
