<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('document_class_configurations', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->integer('class_level'); // 1-12
            $table->enum('document_type', ['certificate', 'declaration'])->default('declaration');
            $table->integer('academic_year')->nullable(); // null = applies to all years
            $table->string('document_title')->nullable(); // Custom title for the document
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->uuid('created_by')->nullable();
            $table->uuid('updated_by')->nullable();
            $table->timestamps();

            $table->unique(['class_level', 'academic_year'], 'unique_class_year');
            $table->index(['class_level', 'is_active']);
        });

        // Insert default configurations
        DB::table('document_class_configurations')->insert([
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'class_level' => 6,
                'document_type' => 'certificate',
                'document_title' => 'Certificado de Conclusão do Ensino Primário',
                'description' => 'Certificado para alunos aprovados na 6ª classe',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'class_level' => 12,
                'document_type' => 'certificate',
                'document_title' => 'Certificado de Conclusão do Ensino Secundário',
                'description' => 'Certificado para alunos aprovados na 12ª classe',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'class_level' => 5,
                'document_type' => 'declaration',
                'document_title' => 'Declaração de Frequência',
                'description' => 'Declaração para alunos da 5ª classe',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'class_level' => 9,
                'document_type' => 'declaration',
                'document_title' => 'Declaração de Conclusão do 1º Ciclo',
                'description' => 'Declaração para alunos aprovados na 9ª classe',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'class_level' => 10,
                'document_type' => 'declaration',
                'document_title' => 'Declaração de Matrícula',
                'description' => 'Declaração para alunos da 10ª classe',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('document_class_configurations');
    }
};
