<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('father_name')->nullable()->after('dob');
            $table->string('mother_name')->nullable()->after('father_name');
            $table->string('birth_place')->nullable()->after('mother_name');
            $table->string('birth_district')->nullable()->after('birth_place');
            $table->string('birth_province')->nullable()->after('birth_district');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['father_name', 'mother_name', 'birth_place', 'birth_district', 'birth_province']);
        });
    }
};
