<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('fee_structures', function (Blueprint $table) {
            $table->boolean('iva_applicable')->default(false)->after('penalty_type');
            $table->boolean('price_includes_iva')->default(false)->after('iva_applicable');
            $table->text('iva_notes')->nullable()->after('price_includes_iva');
        });
    }

    public function down()
    {
        Schema::table('fee_structures', function (Blueprint $table) {
            $table->dropColumn(['iva_applicable', 'price_includes_iva', 'iva_notes']);
        });
    }
};
