<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_reminder_settings', function (Blueprint $table) {
            $table->id();
            $table->string('name')->comment('Nome do lembrete (ex: Lembrete 2 dias)');
            $table->integer('days_before')->comment('Dias antes do vencimento (0 = dia do vencimento)');
            $table->text('message_template')->comment('Template da mensagem SMS');
            $table->boolean('enabled')->default(true)->comment('Ativo/Inativo');
            $table->integer('priority')->default(1)->comment('Ordem de execução');
            $table->timestamps();
        });

        // Inserir configurações padrão
        DB::table('payment_reminder_settings')->insert([
            [
                'name' => 'Lembrete 2 dias antes',
                'days_before' => 2,
                'message_template' => "⚠️ COPMOZ - Lembrete de Pagamento\n\nEstudante: {student_name}\n\n🔔 Lembrete: Sua referência vence em 2 dias!\n\nMes: {fee_month}/{fee_year}\nEntidade: {entity_code}\nReferencia: {reference_number}\nValor: {amount} MT\nVence: {due_date}\n\nPague via eBanking, Balcões, ATMs da RedeSIMO e pelo USSD - BCI",
                'enabled' => true,
                'priority' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Lembrete URGENTE - Último dia',
                'days_before' => 0,
                'message_template' => "⚠️ COPMOZ - ULTIMO DIA!\n\nEstudante: {student_name}\n\n🚨 Hoje é o último dia para pagar sem multa!\n\nMes: {fee_month}/{fee_year}\nEntidade: {entity_code}\nReferencia: {reference_number}\nValor: {amount} MT\nVence HOJE: {due_date}\n\n⏰ Pague URGENTE via eBanking, Balcões, ATMs da RedeSIMO e pelo USSD - BCI",
                'enabled' => true,
                'priority' => 2,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_reminder_settings');
    }
};
