<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('role_permissions', function (Blueprint $table) {
            $table->id();
            $table->unsignedTinyInteger('role')->index(); // Role ID (0-6)
            $table->string('permission_key', 100)->index(); // e.g., 'students.view'
            $table->boolean('granted')->default(true); // Permission granted or not
            $table->timestamps();

            // Each role can only have one entry per permission
            $table->unique(['role', 'permission_key']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('role_permissions');
    }
};
