<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Table for permission groups (e.g., "Estudantes", "POS", etc.)
        Schema::create('permission_groups', function (Blueprint $table) {
            $table->id();
            $table->string('key', 50)->unique(); // e.g., 'students', 'pos'
            $table->string('label', 100); // e.g., 'Estudantes', 'Sistema POS'
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        // Table for permission definitions
        Schema::create('permission_definitions', function (Blueprint $table) {
            $table->id();
            $table->string('key', 100)->unique(); // e.g., 'students.view'
            $table->string('label', 150); // e.g., 'Ver Estudantes'
            $table->text('description')->nullable(); // Optional description
            $table->foreignId('group_id')->constrained('permission_groups')->onDelete('cascade');
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('permission_definitions');
        Schema::dropIfExists('permission_groups');
    }
};
