<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('enrollment_renewals', function (Blueprint $table) {
            $table->uuid('to_classroom_id')->nullable()->after('from_classroom_id');
            $table->foreign('to_classroom_id')->references('id')->on('classrooms')->nullOnDelete();
            $table->timestamp('transitioned_at')->nullable()->after('cancelled_at');
        });
    }

    public function down(): void
    {
        Schema::table('enrollment_renewals', function (Blueprint $table) {
            $table->dropForeign(['to_classroom_id']);
            $table->dropColumn(['to_classroom_id', 'transitioned_at']);
        });
    }
};
