<?php

namespace Database\Seeders;

use App\Models\ExamConfiguration;
use App\Models\Subject;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ExamConfigurationSeeder extends Seeder
{
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        ExamConfiguration::truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        $currentYear = date('Y');

        // Configurações atuais baseadas nos arrays hardcoded

        // 3ª Classe - AF
        $this->createConfigs(3, ['Português', 'Matemática'], 'AF', $currentYear);

        // 6ª Classe - NE
        $this->createConfigs(6, [
            'Português', 'Matemática', 'História', 'Geografia',
            'Física', 'Química', 'Biologia', 'Ciências naturais',
            'Ciências sociais', 'Filosofia'
        ], 'NE', $currentYear);

        // 9ª Classe - NE (NOVO)
        $this->createConfigs(9, [
            'Português', 'Matemática', 'Inglês', 'História',
            'Geografia', 'Física', 'Química', 'Biologia'
        ], 'NE', $currentYear);

        // 10ª Classe - NE
        $this->createConfigs(10, [
            'Português', 'Matemática', 'Inglês', 'História',
            'Geografia', 'Física', 'Química', 'Biologia',
            'Ciências naturais', 'Ciências sociais', 'Filosofia',
            'Francês', 'Geometria Descritiva', 'Desenho'
        ], 'NE', $currentYear);

        // 12ª Classe - NE
        $this->createConfigs(12, [
            'Português', 'Matemática', 'Inglês', 'História',
            'Geografia', 'Física', 'Química', 'Biologia',
            'Ciências naturais', 'Ciências sociais', 'Filosofia',
            'Francês', 'Geometria Descritiva', 'Desenho'
        ], 'NE', $currentYear);

        $this->command->info('✅ Configurações de exames criadas com sucesso!');
    }

    private function createConfigs(int $classLevel, array $subjectNames, string $examType, int $year)
    {
        foreach ($subjectNames as $subjectName) {
            $subject = Subject::where('name', $subjectName)->first();

            if ($subject) {
                ExamConfiguration::create([
                    'subject_id' => $subject->id,
                    'class_level' => $classLevel,
                    'exam_type' => $examType,
                    'is_active' => true,
                    'academic_year' => $year
                ]);

                $this->command->info("   {$classLevel}ª Classe - {$subjectName}: {$examType}");
            } else {
                $this->command->warn("   ⚠️  Disciplina não encontrada: {$subjectName}");
            }
        }
    }
}
