<!doctype html>
<html lang="pt">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Portal do Encarregado — {{ config('app.name') }}</title>
    <link rel="icon" type="image/png" href="{{ asset('assets/images/logo.png') }}">
    <link href="https://fonts.googleapis.com/css?family=Poppins:400,500,600,700&display=swap" rel="stylesheet">
    <link href="{{ asset('assets/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/plugins/font-awesome/css/all.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/css/main.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/css/custom.css') }}" rel="stylesheet">
    <style>
        body { background: #f1f5f9; font-family: 'Poppins', sans-serif; }
        .guardian-navbar {
            background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%);
            box-shadow: 0 2px 8px rgba(30,64,175,.25);
        }
        .student-card {
            cursor: pointer;
            border: 2px solid transparent;
            transition: all .2s;
        }
        .student-card.active, .student-card:hover {
            border-color: #3b82f6;
            box-shadow: 0 4px 12px rgba(59,130,246,.2);
        }
        .fee-badge-paid   { background: #d1fae5; color: #065f46; }
        .fee-badge-pending { background: #fef3c7; color: #92400e; }
    </style>
    @livewireStyles
</head>
<body>
    @if(Auth::guard('guardian')->check())
    <nav class="navbar guardian-navbar py-2 px-4 d-flex justify-content-between align-items-center">
        <div class="d-flex align-items-center gap-2">
            <img src="{{ asset('assets/images/logo.png') }}" height="36" alt="Logo">
            <span class="text-white fw-semibold ms-2">Portal do Encarregado</span>
        </div>
        <div class="d-flex align-items-center gap-3">
            <span class="text-white small">
                <i class="fas fa-user-circle me-1"></i>
                {{ Auth::guard('guardian')->user()->name }}
                <span class="badge bg-white text-primary ms-1">{{ Auth::guard('guardian')->user()->relationship_label }}</span>
            </span>
            <button wire:click="logout" class="btn btn-sm btn-outline-light">
                <i class="fas fa-sign-out-alt me-1"></i>Sair
            </button>
        </div>
    </nav>
    @endif

    <div class='loader' wire:loading>
        <div class='spinner-grow text-primary' role='status'></div>
    </div>

    <div class="container-fluid py-4">
        {{ $slot }}
    </div>

    <script src="{{ asset('assets/plugins/jquery/jquery-3.4.1.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/bootstrap/js/bootstrap.min.js') }}"></script>
    @livewireScripts
    <script src="{{ asset('assets/js/sweetalert.js') }}"></script>
    <x-livewire-alert::scripts />
</body>
</html>
