<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title mb-4">Marcar Presença</h5>

                            <!-- Selection Form -->
                            <div class="row mb-4">
                                <div class="col-md-3">
                                    <label for="year" class="form-label">Ano</label>
                                    <select class="form-control" wire:model="year">
                                        @php
                                            $currentYear = (int)date('Y');
                                        @endphp
                                        @for($y = $currentYear; $y >= 2023; $y--)
                                            <option value="{{ $y }}">{{ $y }}</option>
                                        @endfor
                                    </select>
                                </div>

                                <div class="col-md-4">
                                    <label for="classroom_id" class="form-label">Turma</label>
                                    <select class="form-control @error('classroom_id') is-invalid @enderror"
                                            wire:model="classroom_id">
                                        <option value="">Selecione a turma</option>
                                        @foreach ($classrooms as $classroom)
                                            <option value="{{ $classroom->id }}">{{ $classroom->class }}ª - {{ $classroom->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('classroom_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-3">
                                    <label for="subject_id" class="form-label">Disciplina</label>
                                    <select class="form-control @error('subject_id') is-invalid @enderror"
                                            wire:model="subject_id" {{ empty($classroom_id) ? 'disabled' : '' }}>
                                        <option value="">Selecione a disciplina</option>
                                        @foreach ($subjects as $subject)
                                            <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('subject_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="row mb-4">
                                <div class="col-md-3">
                                    <label for="date" class="form-label">Data</label>
                                    <input type="date" class="form-control @error('date') is-invalid @enderror"
                                           wire:model="date">
                                    @error('date')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-2 d-flex align-items-end">
                                    <button class="btn btn-primary w-100" wire:click="loadStudents"
                                            {{ empty($classroom_id) || empty($subject_id) ? 'disabled' : '' }}>
                                        <span wire:loading wire:target="loadStudents" class="spinner-border spinner-border-sm"></span>
                                        Carregar
                                    </button>
                                </div>
                            </div>

                            <!-- Students Table -->
                            @if($loadedStudents)
                                @if(count($students) > 0)
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <span class="text-muted">{{ count($students) }} estudantes</span>
                                        <div class="btn-group btn-group-sm">
                                            <button class="btn btn-outline-success" wire:click="markAllAs('present')">Todos Presentes</button>
                                            <button class="btn btn-outline-danger" wire:click="markAllAs('absent')">Todos Ausentes</button>
                                        </div>
                                    </div>

                                    <div class="table-responsive">
                                        <table class="table table-hover table-bordered">
                                            <thead class="table-light">
                                                <tr>
                                                    <th style="width: 40px;">#</th>
                                                    <th>Nome</th>
                                                    <th class="text-center" style="width: 120px;">Presente</th>
                                                    <th class="text-center" style="width: 120px;">Ausente</th>
                                                    <th class="text-center" style="width: 120px;">Atrasado</th>
                                                    <th class="text-center" style="width: 120px;">Justificado</th>
                                                    <th style="width: 200px;">Observação</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($students as $index => $student)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>{{ $student->name }}</td>
                                                        <td class="text-center">
                                                            <input type="radio" name="status_{{ $student->id }}"
                                                                   value="present"
                                                                   wire:model="attendanceData.{{ $student->id }}.status"
                                                                   class="form-check-input">
                                                        </td>
                                                        <td class="text-center">
                                                            <input type="radio" name="status_{{ $student->id }}"
                                                                   value="absent"
                                                                   wire:model="attendanceData.{{ $student->id }}.status"
                                                                   class="form-check-input">
                                                        </td>
                                                        <td class="text-center">
                                                            <input type="radio" name="status_{{ $student->id }}"
                                                                   value="late"
                                                                   wire:model="attendanceData.{{ $student->id }}.status"
                                                                   class="form-check-input">
                                                        </td>
                                                        <td class="text-center">
                                                            <input type="radio" name="status_{{ $student->id }}"
                                                                   value="justified"
                                                                   wire:model="attendanceData.{{ $student->id }}.status"
                                                                   class="form-check-input">
                                                        </td>
                                                        <td>
                                                            <input type="text" class="form-control form-control-sm"
                                                                   wire:model.lazy="attendanceData.{{ $student->id }}.observation"
                                                                   placeholder="Obs...">
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>

                                    <div class="mt-3">
                                        <button class="btn btn-success" wire:click="saveAttendance">
                                            <span wire:loading wire:target="saveAttendance" class="spinner-border spinner-border-sm"></span>
                                            <i class="fas fa-save me-1"></i> Salvar Presença
                                        </button>
                                    </div>
                                @else
                                    <div class="alert alert-warning">
                                        <i class="fas fa-exclamation-triangle me-1"></i> Nenhum estudante encontrado nesta turma para o ano {{ $year }}.
                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
