<div class="modal fade" id="modal_{{ $model->id }}" tabindex="-1" aria-labelledby="exampleModalLabel"
    aria-hidden="true" wire:ignore.self>
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Nome do estudante: {{ $model->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form class="row g-3" wire:submit.prevent="submit">
                    <div class="col-md-12">
                        <label for="subject" class="form-label">Disciplina</label>
                        <select class="form-control @error('subject_id') is-invalid @enderror" id="subject"
                            wire:model="subject_id">
                            <option value="" selected>Por favor selecione disciplina</option>
                            @foreach ($subjects as $subject)
                                <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                            @endforeach
                        </select>
                        @error('subject_id')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-12">
                        <label for="trimester" class="form-label">Trimestre</label>
                        <select class="form-control @error('trimester_id') is-invalid @enderror" id="trimester"
                            wire:model="trimester_id">
                            <option value="">Selecione trimestre</option>
                            <option value="1">Primeiro trimestre</option>
                            <option value="2">Segundo trimestre</option>
                            <option value="3">Terceiro trimestre</option>
                        </select>
                        @error('trimester_id')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                        <div class="col-md-12">
                            <label for="testType" class="form-label">Tipo de teste</label>
                            <select class="form-control @error('type') is-invalid @enderror" id="testType" wire:model="type">
                                <option value="" selected>Selecione o tipo de teste</option>
                                <option value="1">ACS1</option>
                                <option value="2">ACS2</option>
                                <option value="3">AT</option>
                                @if ($trimester_id == 3 && ($studentClass == 6 || $studentClass == 10 || $studentClass == 12))
                                    <option value="4">NE</option>
                                @elseif ($trimester_id == 3 && ($studentClass == 3))
                                    <option value="4">AF</option>
                                @endif
                            </select>
                            @error('type')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                    <div class="col-md-12">
                        <label for="MACS" class="form-label">Nota</label>
                        <input type="text" class="form-control @error('MACS') is-invalid @enderror" id="MACS"
                            required placeholder="Insira nota..." wire:model="MACS">
                        @error('MACS')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mt-3">
                    <button type="button" class="btn btn-primary float-end" wire:click="submit">
                        <span wire:loading wire:target="submit" class="spinner-border spinner-border-sm"></span>
                        Guardar
                    </button>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

