<div>
    <div class="page-content">
        <div class="main-wrapper">
            <!-- Header -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-1"><i class="fas fa-id-card me-2 text-primary"></i>Cartão de Estudante</h4>
                            <p class="text-muted mb-0">Gerar e gerir cartões de identificação dos estudantes</p>
                        </div>
                        <div>
                            <span class="badge bg-primary fs-6">Ano Lectivo: {{ $academicYear }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="rounded-circle p-3" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                    <i class="fas fa-users text-white fa-lg"></i>
                                </div>
                                <div class="ms-3">
                                    <h6 class="text-muted mb-1">Total Estudantes</h6>
                                    <h3 class="fw-bold mb-0">{{ $stats['total_students'] ?? 0 }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="rounded-circle p-3" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                                    <i class="fas fa-id-card text-white fa-lg"></i>
                                </div>
                                <div class="ms-3">
                                    <h6 class="text-muted mb-1">Cartoes Gerados</h6>
                                    <h3 class="fw-bold mb-0">{{ $stats['total_cards'] ?? 0 }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="rounded-circle p-3" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                                    <i class="fas fa-clock text-white fa-lg"></i>
                                </div>
                                <div class="ms-3">
                                    <h6 class="text-muted mb-1">Pendentes</h6>
                                    <h3 class="fw-bold mb-0">{{ $stats['cards_pending'] ?? 0 }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tabs -->
            <ul class="nav nav-tabs mb-4" role="tablist">
                <li class="nav-item">
                    <a class="nav-link {{ $activeTab === 'generate' ? 'active' : '' }}"
                       href="#" wire:click.prevent="$set('activeTab', 'generate')">
                        <i class="fas fa-plus-circle me-2"></i>Gerar Cartoes
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ $activeTab === 'list' ? 'active' : '' }}"
                       href="#" wire:click.prevent="$set('activeTab', 'list')">
                        <i class="fas fa-list me-2"></i>Lista de Estudantes
                    </a>
                </li>
            </ul>

            <!-- Tab Content -->
            @if($activeTab === 'generate')
            <!-- Generate Tab -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-id-card me-2"></i>Gerar Cartoes de Estudante</h5>
                </div>
                <div class="card-body">
                    <!-- Selection Row -->
                    <div class="row g-3 mb-4">
                        <div class="col-md-4">
                            <label class="form-label">Classe</label>
                            <select class="form-select" wire:model="selectedClass">
                                <option value="">-- Seleccione a Classe --</option>
                                @foreach($availableClasses as $class)
                                    <option value="{{ $class }}">{{ $class }}a Classe</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Turma</label>
                            <select class="form-select" wire:model="selectedTurma" {{ empty($availableTurmas) ? 'disabled' : '' }}>
                                <option value="">-- Seleccione a Turma --</option>
                                @foreach($availableTurmas as $turma)
                                    <option value="{{ $turma->id }}">{{ $turma->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 d-flex align-items-end">
                            <button class="btn btn-primary w-100" wire:click="checkStudents"
                                    {{ !$selectedTurma ? 'disabled' : '' }}>
                                <i class="fas fa-search me-2"></i>Verificar Estudantes
                            </button>
                        </div>
                    </div>

                    @if($showStudentsList)
                    <!-- Results -->
                    <div class="row">
                        <!-- Students without cards -->
                        <div class="col-md-6">
                            <div class="card border-warning">
                                <div class="card-header bg-warning text-dark d-flex justify-content-between align-items-center">
                                    <span><i class="fas fa-exclamation-triangle me-2"></i>Sem Cartao ({{ count($studentsWithoutCards) }})</span>
                                    @if(count($studentsWithoutCards) > 0)
                                    <button class="btn btn-sm btn-success" wire:click="requestBatchGeneration">
                                        <i class="fas fa-magic me-1"></i>Gerar Todos
                                    </button>
                                    @endif
                                </div>
                                <div class="card-body" style="max-height: 400px; overflow-y: auto;">
                                    @forelse($studentsWithoutCards as $student)
                                    <div class="d-flex justify-content-between align-items-center border-bottom py-2">
                                        <div>
                                            <strong>{{ $student['name'] }}</strong>
                                            <br><small class="text-muted">ID: {{ $student['student_id'] }}</small>
                                        </div>
                                        <button class="btn btn-sm btn-primary" wire:click="generateIndividualCard('{{ $student['id'] }}')">
                                            <i class="fas fa-plus"></i>
                                        </button>
                                    </div>
                                    @empty
                                    <p class="text-muted text-center">Todos os estudantes desta turma ja tem cartao.</p>
                                    @endforelse
                                </div>
                            </div>
                        </div>

                        <!-- Students with cards -->
                        <div class="col-md-6">
                            <div class="card border-success">
                                <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                                    <span><i class="fas fa-check-circle me-2"></i>Com Cartao ({{ count($studentsWithCards) }})</span>
                                    @if(count($studentsWithCards) > 0)
                                    <button class="btn btn-sm btn-light" wire:click="downloadBatchZip">
                                        <i class="fas fa-download me-1"></i>Baixar ZIP
                                    </button>
                                    @endif
                                </div>
                                <div class="card-body" style="max-height: 400px; overflow-y: auto;">
                                    @forelse($studentsWithCards as $item)
                                    <div class="d-flex justify-content-between align-items-center border-bottom py-2">
                                        <div>
                                            <strong>{{ $item['student']['name'] }}</strong>
                                            <br><small class="text-muted">ID: {{ $item['student']['student_id'] }}</small>
                                        </div>
                                        <div>
                                            <button class="btn btn-sm btn-outline-primary me-1" wire:click="downloadCard('{{ $item['student']['id'] }}')" title="Baixar">
                                                <i class="fas fa-download"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-warning" wire:click="regenerateCard('{{ $item['student']['id'] }}')" title="Regenerar">
                                                <i class="fas fa-sync"></i>
                                            </button>
                                        </div>
                                    </div>
                                    @empty
                                    <p class="text-muted text-center">Nenhum estudante com cartao nesta turma.</p>
                                    @endforelse
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            @elseif($activeTab === 'list')
            <!-- List Tab -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <h5 class="mb-0"><i class="fas fa-list me-2"></i>Lista de Estudantes</h5>
                        </div>
                        <div class="col-md-6">
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-search"></i></span>
                                <input type="text" class="form-control" placeholder="Pesquisar por nome ou ID..."
                                       wire:model.debounce.300ms="searchTerm">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Estudante</th>
                                    <th>ID</th>
                                    <th>Turma</th>
                                    <th class="text-center">Status</th>
                                    <th class="text-center">Accoes</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($students as $student)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($student->avatar)
                                            <img src="{{ asset('storage/'.$student->avatar) }}" class="rounded-circle me-2" width="32" height="32">
                                            @else
                                            <div class="rounded-circle bg-secondary text-white d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px;">
                                                {{ strtoupper(substr($student->name, 0, 1)) }}
                                            </div>
                                            @endif
                                            {{ $student->name }}
                                        </div>
                                    </td>
                                    <td>{{ $student->student_id }}</td>
                                    <td>{{ $student->classroom->name ?? '-' }}</td>
                                    <td class="text-center">
                                        @if($student->has_card)
                                        <span class="badge bg-success"><i class="fas fa-check me-1"></i>Gerado</span>
                                        @else
                                        <span class="badge bg-warning text-dark"><i class="fas fa-clock me-1"></i>Pendente</span>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        @if($student->has_card)
                                        <button class="btn btn-sm btn-primary me-1" wire:click="downloadCard('{{ $student->id }}')" title="Baixar">
                                            <i class="fas fa-download"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" wire:click="regenerateCard('{{ $student->id }}')" title="Regenerar">
                                            <i class="fas fa-sync"></i>
                                        </button>
                                        @else
                                        <button class="btn btn-sm btn-success" wire:click="generateIndividualCard('{{ $student->id }}')" title="Gerar">
                                            <i class="fas fa-plus"></i> Gerar
                                        </button>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center py-4 text-muted">
                                        <i class="fas fa-search fa-2x mb-2"></i>
                                        <p>Nenhum estudante encontrado</p>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer bg-white">
                    {{ $students->links() }}
                </div>
            </div>
            @endif

            <!-- Processing Overlay -->
            @if($isProcessing)
            <div class="position-fixed top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center" style="background: rgba(0,0,0,0.5); z-index: 9999;">
                <div class="card p-4 text-center">
                    <div class="spinner-border text-primary mb-3" role="status"></div>
                    <h5>Gerando cartoes...</h5>
                    <p class="text-muted mb-0">Por favor aguarde</p>
                </div>
            </div>
            @endif
        </div>
    </div>

    <script>
        document.addEventListener('livewire:load', function () {
            Livewire.on('openUrl', url => {
                window.open(url, '_blank');
            });
        });
    </script>
</div>
