<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="card border-0 shadow">
                <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-file-download me-2"></i>
                        Adicionar Matrizes
                    </h2>
                    <a href="{{ route('admin.downloads') }}" class="btn btn-sm btn-light">
                        <i class="fas fa-list me-1"></i>Ver Todas as Matrizes
                    </a>
                </div>

                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-12 col-lg-10">
                            <form wire:submit.prevent="submit" class="needs-validation" novalidate>
                                <div class="row g-3">
                                    <!-- Enviar Para -->
                                    <div class="col-md-6">
                                        <label for="type" class="form-label fw-semibold">Enviar Para <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-users"></i></span>
                                            <select id="type"
                                                    wire:model="type"
                                                    class="form-select"
                                                    required>
                                                <option value="all">Todos</option>
                                                <option value="class">Classe Ou Turma</option>
                                                <option value="student">Estudante</option>
                                            </select>
                                        </div>
                                    </div>

                                    <!-- Título -->
                                    <div class="col-md-6">
                                        <label for="title" class="form-label fw-semibold">Título <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-heading"></i></span>
                                            <input type="text"
                                                   id="title"
                                                   wire:model="title"
                                                   class="form-control @error('title') is-invalid @enderror"
                                                   placeholder="Ex: Matriz de Matemática 10ª Classe"
                                                   required>
                                        </div>
                                        @error('title') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Turma (condicional) -->
                                    @if($type == "class")
                                    <div class="col-12">
                                        <label for="class_ids" class="form-label fw-semibold">
                                            Turmas <span class="text-danger">*</span>
                                            <small class="text-muted">(Segure Ctrl/Cmd para selecionar múltiplas turmas)</small>
                                        </label>
                                        <div class="turma-select-wrapper">
                                            <select id="class_ids"
                                                    wire:model="class_ids"
                                                    class="form-select turma-multiselect @error('class_ids') is-invalid @enderror"
                                                    multiple
                                                    size="8"
                                                    required>
                                                @foreach($Classroom as $class)
                                                    <option value="{{ $class->id }}">{{ $class->class }}ª Classe - {{ $class->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @error('class_ids') <span class="text-danger small">{{ $message }}</span> @enderror
                                        @if(!empty($class_ids))
                                            <div class="mt-2">
                                                <small class="text-success">
                                                    <i class="fas fa-check-circle me-1"></i>
                                                    {{ count($class_ids) }} turma(s) selecionada(s)
                                                </small>
                                            </div>
                                        @endif
                                    </div>
                                    @endif

                                    @if($type == "student")
                                    <div class="col-md-6">
                                        <label for="class_id" class="form-label fw-semibold">Turma <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-door-open"></i></span>
                                            <select id="class_id"
                                                    wire:model="class_id"
                                                    class="form-select @error('class_id') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione a turma...</option>
                                                @foreach($Classroom as $class)
                                                    <option value="{{ $class->id }}">{{ $class->class }}ª - {{ $class->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @error('class_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                    @endif

                                    <!-- Estudante (condicional) -->
                                    @if($type == "student")
                                    <div class="col-md-6">
                                        <label for="student_id" class="form-label fw-semibold">Estudante <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-user-graduate"></i></span>
                                            <select id="student_id"
                                                    wire:model="student_id"
                                                    class="form-select @error('student_id') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione o estudante...</option>
                                                @foreach($students as $student)
                                                    <option value="{{ $student->id }}">{{ $student->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @error('student_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                    @endif

                                    <!-- Autor -->
                                    <div class="col-md-6">
                                        <label for="author" class="form-label fw-semibold">Autor <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-user-edit"></i></span>
                                            <input type="text"
                                                   id="author"
                                                   wire:model="author"
                                                   class="form-control @error('author') is-invalid @enderror"
                                                   placeholder="Ex: Prof. João Silva"
                                                   required>
                                        </div>
                                        @error('author') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Descrição -->
                                    <div class="col-12">
                                        <label for="description" class="form-label fw-semibold">Descrição</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light align-items-start pt-2"><i class="fas fa-align-left"></i></span>
                                            <input type="text"
                                                   id="description"
                                                   wire:model="description"
                                                   class="form-control @error('description') is-invalid @enderror"
                                                   placeholder="Breve descrição sobre o conteúdo...">
                                        </div>
                                        @error('description') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Ficheiros -->
                                    <div class="col-12">
                                        <label for="photos" class="form-label fw-semibold">Ficheiros <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-file-upload"></i></span>
                                            <input type="file"
                                                   id="photos"
                                                   wire:model="photos"
                                                   class="form-control @error('photos.*') is-invalid @enderror"
                                                   multiple
                                                   required>
                                        </div>
                                        <small class="text-muted">Pode selecionar múltiplos ficheiros</small>
                                        @error('photos.*') <span class="text-danger small d-block">{{ $message }}</span> @enderror
                                        <div wire:loading wire:target="photos" class="mt-2">
                                            <small class="text-primary">
                                                <span class="spinner-border spinner-border-sm me-1"></span>
                                                Carregando ficheiros...
                                            </small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Botões -->
                                <div class="d-grid gap-2 mt-4">
                                    <button type="submit"
                                            class="btn btn-primary btn-lg"
                                            wire:loading.attr="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:loading.remove wire:target="submit">
                                            <i class="fas fa-save me-2"></i>Guardar Matriz
                                        </span>
                                        <span wire:loading wire:target="submit">
                                            <span class="spinner-border spinner-border-sm me-2"></span>
                                            Processando...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-label.fw-semibold {
            font-weight: 600;
            color: #495057;
        }

        .input-group-text {
            background-color: #f8f9fa;
            border-right: none;
        }

        .input-group .form-control,
        .input-group .form-select {
            border-left: none;
        }

        .input-group .form-control:focus,
        .input-group .form-select:focus {
            border-color: #ced4da;
            box-shadow: none;
        }

        .input-group:focus-within .input-group-text {
            border-color: #80bdff;
        }

        /* Multi-select turma styles */
        .turma-select-wrapper {
            position: relative;
        }

        .turma-multiselect {
            min-height: 200px !important;
            border: 2px solid #e3e6f0;
            border-radius: 0.35rem;
            padding: 0.5rem;
            background-color: #fff;
        }

        .turma-multiselect:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }

        .turma-multiselect option {
            padding: 0.75rem;
            margin-bottom: 0.25rem;
            border-radius: 0.25rem;
            cursor: pointer;
            transition: all 0.2s;
        }

        .turma-multiselect option:hover {
            background-color: #e7f3ff;
            color: #0066cc;
        }

        .turma-multiselect option:checked {
            background: linear-gradient(135deg, #0066cc 0%, #004c99 100%);
            color: white;
            font-weight: 600;
        }

        .turma-multiselect option:checked:hover {
            background: linear-gradient(135deg, #004c99 0%, #003366 100%);
        }
    </style>
</div>
