<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Adicionar nota do estudante</h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Nome do estudante </label>
                                    <select class="form-control @error('student_id') is-invalid @enderror"
                                            id="name" wire:model="student_id"
                                            class="form-control input-lg dynamic">
                                        <option value="">Selecione o estudante</option>
                                        @foreach($students as $student)
                                            <option value="{{ $student->id }}"> {{ $student->name }} </option>
                                        @endforeach
                                    </select>
                                    @error('student_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Disciplina </label>
                                    <select class="form-control @error('subject_id') is-invalid @enderror"
                                            id="name" wire:model="subject_id"
                                            class="form-control input-lg dynamic">
                                        <option value="">Por favor selecione a disciplina</option>
                                        @foreach($subjects as $subject)
                                            <option value="{{ $subject->id }}"> {{ $subject->name }} </option>
                                        @endforeach
                                    </select>
                                    @error('subject_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Trimestre </label>
                                    <select class="form-control @error('trimester_id') is-invalid @enderror"
                                            id="trimester_id" wire:model="trimester_id"
                                            class="form-control input-lg dynamic">
                                        <option value="">Selecione o trimestre</option>
                                        @foreach($trimesters as $trimester)
                                            <option value="{{ $trimester->id }}"> {{ $trimester->name }} </option>
                                        @endforeach
                                    </select>
                                    @error('trimester_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="MACS" class="form-label">ACS1</label>
                                    <input type="text"
                                           class="form-control @error('MACS') is-invalid @enderror"
                                           id="MACS" required placeholder="Insira a nota..."
                                           wire:model="MACS">
                                    @error('MACS')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled"><span wire:target="submit"
                                                                               wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Guardar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
