{{-- resources/views/livewire/admin/exams/configure-exams.blade.php --}}

<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-header bg-primary text-white">
                            <div class="d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">
                                    <i class="fas fa-cog"></i> Configurar Exames (NE/AF) por Classe e Disciplina
                                </h5>
                                <button class="btn btn-sm btn-light" wire:click="$toggle('showFilters')">
                                    <i class="fas fa-filter"></i>
                                    {{ $showFilters ? 'Ocultar' : 'Mostrar' }} Filtros
                                </button>
                            </div>
                        </div>

                        <div class="card-body">
                            {{-- Filtros --}}
                            @if($showFilters)
                            <div class="row mb-4">
                                <div class="col-md-4">
                                    <label class="form-label">
                                        <i class="fas fa-graduation-cap"></i> Classe
                                    </label>
                                    <select wire:model="class_level" class="form-control">
                                        <option value="">Selecione a classe...</option>
                                        @for($i = 1; $i <= 12; $i++)
                                            <option value="{{ $i }}">{{ $i }}ª Classe</option>
                                        @endfor
                                    </select>
                                </div>

                                <div class="col-md-4">
                                    <label class="form-label">
                                        <i class="fas fa-calendar-alt"></i> Ano Letivo
                                    </label>
                                    <select wire:model="academic_year" class="form-control">
                                        @php
                                            $currentYear = date('Y');
                                        @endphp
                                        @for($year = $currentYear - 1; $year <= $currentYear + 2; $year++)
                                            <option value="{{ $year }}">{{ $year }}</option>
                                        @endfor
                                    </select>
                                </div>

                                <div class="col-md-4 d-flex align-items-end flex-wrap gap-2">
                                    {{-- Botão para copiar TODAS as classes --}}
                                    <button wire:click="copyAllClassesFromPreviousYear"
                                            class="btn btn-info"
                                            title="Copiar TODAS as configurações do ano anterior (todas as classes)">
                                        <i class="fas fa-clone"></i> Copiar Tudo de {{ $academic_year - 1 }}
                                    </button>

                                    @if($class_level)
                                    <button wire:click="copyFromPreviousYear"
                                            class="btn btn-outline-info"
                                            title="Copiar apenas {{ $class_level }}ª classe do ano anterior">
                                        <i class="fas fa-copy"></i> Copiar {{ $class_level }}ª
                                    </button>

                                    <button wire:click="resetAll"
                                            class="btn btn-outline-danger"
                                            title="Remover todos os exames desta classe">
                                        <i class="fas fa-times-circle"></i> Limpar
                                    </button>
                                    @endif
                                </div>
                            </div>
                            @endif

                            {{-- Estatísticas --}}
                            @if($class_level && count($configurations) > 0)
                            <div class="row mb-4">
                                <div class="col-md-4">
                                    <div class="card border-primary">
                                        <div class="card-body text-center">
                                            <h3 class="text-primary mb-0">{{ $totalSubjects }}</h3>
                                            <small class="text-muted">Total de Disciplinas</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="card border-success">
                                        <div class="card-body text-center">
                                            <h3 class="text-success mb-0">{{ $subjectsWithNE }}</h3>
                                            <small class="text-muted">Com NE</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="card border-info">
                                        <div class="card-body text-center">
                                            <h3 class="text-info mb-0">{{ $subjectsWithAF }}</h3>
                                            <small class="text-muted">Com AF</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif

                            {{-- Tabela de Configurações --}}
                            @if($class_level)
                                @if(count($configurations) > 0)
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle"></i>
                                    <strong>Instruções:</strong>
                                    <ul class="mb-0 mt-2">
                                        <li><strong>NE (Nota de Exame):</strong> Para classes de exame (6ª, 9ª, 10ª, 12ª, etc.)</li>
                                        <li><strong>AF (Avaliação Final):</strong> Para 3ª classe ou outras específicas</li>
                                        <li><strong>Sem exame:</strong> A disciplina não terá coluna NE/AF nos relatórios</li>
                                        <li>Células <span class="badge badge-secondary" style="background-color: #000; color: white;">pintadas de preto</span> aparecem nas disciplinas sem exame</li>
                                    </ul>
                                </div>

                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover">
                                        <thead class="table-primary">
                                            <tr>
                                                <th width="5%">#</th>
                                                <th width="40%">
                                                    <i class="fas fa-book"></i> Disciplina
                                                </th>
                                                <th width="30%">
                                                    <i class="fas fa-file-alt"></i> Tipo de Exame
                                                </th>
                                                <th width="25%">
                                                    <i class="fas fa-eye"></i> Visualização no Relatório
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $count = 1; @endphp
                                            @foreach($configurations as $subjectId => $config)
                                            <tr>
                                                <td class="text-center">{{ $count++ }}</td>
                                                <td>
                                                    <strong>{{ $config['name'] }}</strong>
                                                </td>
                                                <td>
                                                    <select wire:model="configurations.{{ $subjectId }}.exam_type"
                                                            class="form-control"
                                                            wire:change="calculateStatistics">
                                                        <option value="none">Sem exame</option>
                                                        <option value="NE">NE (Nota de Exame)</option>
                                                        <option value="AF">AF (Avaliação Final)</option>
                                                    </select>
                                                </td>
                                                <td class="text-center">
                                                    @if($config['exam_type'] == 'NE')
                                                        <span class="badge badge-success badge-lg" style="background-color: #28a745; color: white; font-size: 14px;">
                                                            <i class="fas fa-check-circle"></i> Mostra coluna NE
                                                        </span>
                                                    @elseif($config['exam_type'] == 'AF')
                                                        <span class="badge badge-info badge-lg" style="background-color: #17a2b8; color: white; font-size: 14px;">
                                                            <i class="fas fa-check-circle"></i> Mostra coluna AF
                                                        </span>
                                                    @else
                                                        <span class="badge badge-secondary badge-lg" style="background-color: #6c757d; color: white; font-size: 14px;">
                                                            <i class="fas fa-times-circle"></i> Célula preta (sem exame)
                                                        </span>
                                                    @endif
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                {{-- Botões de Ação --}}
                                <div class="d-flex justify-content-between align-items-center mt-4">
                                    <div>
                                        <small class="text-muted">
                                            <i class="fas fa-info-circle"></i>
                                            Configurando: <strong>{{ $class_level }}ª Classe</strong> |
                                            Ano: <strong>{{ $academic_year }}</strong>
                                        </small>
                                    </div>
                                    <div>
                                        <button wire:click="submit" class="btn btn-primary btn-lg">
                                            <i class="fas fa-save"></i>
                                            <span wire:loading.remove wire:target="submit">Salvar Configurações</span>
                                            <span wire:loading wire:target="submit">
                                                <span class="spinner-border spinner-border-sm" role="status"></span>
                                                Salvando...
                                            </span>
                                        </button>
                                    </div>
                                </div>
                                @else
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle"></i>
                                    Nenhuma disciplina encontrada. Certifique-se de que existem disciplinas cadastradas no sistema.
                                </div>
                                @endif
                            @else
                            <div class="alert alert-secondary text-center py-5">
                                <i class="fas fa-arrow-up fa-3x mb-3 text-muted"></i>
                                <h5>Selecione uma classe acima para começar a configurar</h5>
                                <p class="text-muted">
                                    Você poderá definir quais disciplinas terão NE (Nota de Exame) ou AF (Avaliação Final)
                                </p>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
