<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Selecionar Critérios</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="class" class="form-label">Classe</label>
                                    <!-- Updated select to bind the selected class -->
                                    <select class="form-control" wire:model="selectedClass">
                                        <option value="">Selecione a classe</option>
                                        @foreach ($Classroom as $class)
                                            <option value="{{ $class->id }}">{{ $class->class }} {{ $class->name }} </option>
                                        @endforeach
                                    </select>
                                    <span class="invalid-feedback" role="alert"></span>
                                </div>
                            </div>
                            <form id="assign-group-form" wire:submit.prevent="assignFeeGroup">
                                @csrf
                            <!-- Display Matching Fee Group Data -->
                            <div class="row mt-4">
                                <div class="col-md-4">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th colspan="2">{{ $feeGroupName }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($matchedFees as $fee)
                                                <tr>
                                                    <td> <input type="radio" wire:model="selectedFeeGroup" name="fee_group_id" value="{{ $fee->id }}" required />
                                                        <!--- $fee->feeType->name ----></td>
                                                    <td>{{ $fee->amount }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                <!-- Right side table for students -->
                                <div class="col-md-8">
                                    <h5 class="card-title">Lista de Estudantes</h5>
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th><input type="checkbox" id="select-all" /> Selecionar Todos</th>
                                                <th>Nome</th>
                                                <th>Genero</th>
                                                <th>Email</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($students as $student)
                                                <tr>
                                                    <td><input type="checkbox" wire:model="selectedStudents" class="student-checkbox" value="{{ $student->id }}" /></td>
                                                    <td>{{ $student->name }}</td>
                                                    <td>{{ $student->sex }}</td>
                                                    <td>{{ $student->email }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <button type="submit" class="btn btn-primary btn-lg float-end" ><span wire:target="submit" wire:loading.class="spinner-border spinner-border-lg"></span>
                                    Atribuir Taxas aos Estudantes
                                    </button>
                                
                            </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('livewire:load', function() {
        setupSelectAllCheckbox();
    });

    document.addEventListener('livewire:update', function() {
        setupSelectAllCheckbox();
    });

    function setupSelectAllCheckbox() {
        const selectAllCheckbox = document.getElementById('select-all');
        const studentCheckboxes = document.querySelectorAll('.student-checkbox');

        selectAllCheckbox.addEventListener('change', function() {
            studentCheckboxes.forEach(function(checkbox) {
                checkbox.checked = selectAllCheckbox.checked;
            });
        });
    }
</script>

