<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="card border-0 shadow">
                <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-clipboard-list me-2"></i>
                        Adicionar Matriz
                    </h2>
                    <a href="{{ route('admin.list.grades') }}" class="btn btn-sm btn-light">
                        <i class="fas fa-list me-1"></i>Ver Todas as Matrizes
                    </a>
                </div>

                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-12 col-md-10 col-lg-8 col-xl-7">
                            <form wire:submit.prevent="submit" class="needs-validation" novalidate>
                                <!-- Nome da Turma -->
                                <div class="form-group mb-3">
                                    <label for="name" class="form-label fw-semibold">Turma <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-tag"></i></span>
                                        <input type="text"
                                               id="name"
                                               wire:model="name"
                                               class="form-control @error('name') is-invalid @enderror"
                                               placeholder="Ex: Turma A"
                                               required>
                                    </div>
                                    @error('name') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <!-- Classe -->
                                <div class="form-group mb-4">
                                    <label for="class" class="form-label fw-semibold">Classe <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-layer-group"></i></span>
                                        <select id="class"
                                                wire:model="class"
                                                class="form-select @error('class') is-invalid @enderror"
                                                required>
                                            <option value="">Selecione a classe...</option>
                                            @for($i = 1; $i <= 12; $i++)
                                                <option value="{{ $i }}">{{ $i }}ª Classe</option>
                                            @endfor
                                        </select>
                                    </div>
                                    @error('class') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <!-- Botões -->
                                <div class="d-grid gap-2">
                                    <button type="submit"
                                            class="btn btn-primary btn-lg"
                                            wire:loading.attr="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:loading.remove wire:target="submit">
                                            <i class="fas fa-save me-2"></i>Guardar
                                        </span>
                                        <span wire:loading wire:target="submit">
                                            <span class="spinner-border spinner-border-sm me-2"></span>
                                            Processando...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-label.fw-semibold {
            font-weight: 600;
            color: #495057;
        }

        .input-group-text {
            background-color: #f8f9fa;
            border-right: none;
        }

        .input-group .form-control,
        .input-group .form-select {
            border-left: none;
        }

        .input-group .form-control:focus,
        .input-group .form-select:focus {
            border-color: #ced4da;
            box-shadow: none;
        }

        .input-group:focus-within .input-group-text {
            border-color: #80bdff;
        }
    </style>
</div>
