<div class="page-content">
    <div class="main-wrapper">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1"><i class="fas fa-tags text-primary me-2"></i>Gestão de Categorias</h4>
                        <p class="text-muted mb-0">Organize os produtos por categorias</p>
                    </div>
                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.pos.products') }}" class="btn btn-outline-primary">
                            <i class="fas fa-arrow-left me-1"></i> Voltar para Produtos
                        </a>
                        <button wire:click="openModal" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Nova Categoria
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Search -->
        <div class="row mb-3">
            <div class="col-md-4">
                <input
                    type="text"
                    wire:model.debounce.300ms="search"
                    class="form-control"
                    placeholder="Pesquisar categorias..."
                />
            </div>
        </div>

        <!-- Categories Grid -->
        <div class="row">
            @forelse($categories as $category)
                <div class="col-md-4 mb-4">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div class="d-flex align-items-center">
                                    <div class="me-3" style="width: 50px; height: 50px; background-color: {{ $category->color }}; border-radius: 10px; display: flex; align-items: center; justify-content: center;">
                                        @if($category->icon)
                                            <i class="fas fa-{{ $category->icon }} fa-2x text-white"></i>
                                        @else
                                            <i class="fas fa-tag fa-2x text-white"></i>
                                        @endif
                                    </div>
                                    <div>
                                        <h5 class="mb-0">{{ $category->name }}</h5>
                                        <small class="text-muted">{{ $category->products_count }} produtos</small>
                                    </div>
                                </div>
                                <div>
                                    @if($category->is_active)
                                        <span class="badge bg-success">Ativo</span>
                                    @else
                                        <span class="badge bg-secondary">Inativo</span>
                                    @endif
                                </div>
                            </div>

                            @if($category->description)
                                <p class="text-muted mb-3">{{ $category->description }}</p>
                            @endif

                            <div class="d-flex gap-2">
                                <button wire:click="edit('{{ $category->id }}')" class="btn btn-sm btn-primary flex-fill">
                                    <i class="fas fa-edit me-1"></i> Editar
                                </button>
                                <button wire:click="confirmDelete('{{ $category->id }}')" class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-12">
                    <div class="card shadow-sm">
                        <div class="card-body text-center py-5">
                            <i class="fas fa-tags fa-4x text-muted mb-3"></i>
                            <p class="text-muted mb-0">Nenhuma categoria encontrada</p>
                            <button wire:click="openModal" class="btn btn-primary mt-3">
                                <i class="fas fa-plus me-1"></i> Criar Primeira Categoria
                            </button>
                        </div>
                    </div>
                </div>
            @endforelse
        </div>

        <!-- Pagination -->
        <div class="mt-3">
            {{ $categories->links() }}
        </div>

        <!-- Modal -->
        @if($showModal)
            <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header bg-primary text-white">
                            <h5 class="modal-title">
                                <i class="fas fa-{{ $editMode ? 'edit' : 'plus' }} me-2"></i>
                                {{ $editMode ? 'Editar Categoria' : 'Nova Categoria' }}
                            </h5>
                            <button type="button" class="btn-close btn-close-white" wire:click="closeModal"></button>
                        </div>
                        <div class="modal-body">
                            <form wire:submit.prevent="save">
                                <div class="mb-3">
                                    <label class="form-label">Nome da Categoria <span class="text-danger">*</span></label>
                                    <input type="text" wire:model="name" class="form-control @error('name') is-invalid @enderror" placeholder="Ex: Uniformes Escolares" />
                                    @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Descrição</label>
                                    <textarea wire:model="description" class="form-control" rows="2" placeholder="Descrição opcional da categoria"></textarea>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Ícone (FontAwesome)</label>
                                        <input type="text" wire:model="icon" class="form-control" placeholder="Ex: tshirt, book, utensils" />
                                        <small class="text-muted">
                                            <a href="https://fontawesome.com/icons" target="_blank">Ver ícones</a>
                                        </small>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Cor <span class="text-danger">*</span></label>
                                        <input type="color" wire:model="color" class="form-control form-control-color w-100" />
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" wire:model="is_active" id="isActiveCategory">
                                        <label class="form-check-label" for="isActiveCategory">Categoria Ativa</label>
                                    </div>
                                </div>

                                <!-- Preview -->
                                @if($name)
                                    <div class="alert alert-info">
                                        <strong>Pré-visualização:</strong>
                                        <div class="d-flex align-items-center mt-2">
                                            <div style="width: 40px; height: 40px; background-color: {{ $color }}; border-radius: 8px; display: flex; align-items: center; justify-content: center;" class="me-2">
                                                @if($icon)
                                                    <i class="fas fa-{{ $icon }} text-white"></i>
                                                @endif
                                            </div>
                                            <span>{{ $name }}</span>
                                        </div>
                                    </div>
                                @endif
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" wire:click="closeModal">Cancelar</button>
                            <button type="button" wire:click="save" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i> Salvar
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
