<div class="page-content">
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4 mt-3">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="pt-3">
                        <h1 class="h3 mb-1 text-primary">
                            <i class="fas fa-sms me-2"></i>Lista de SMS
                        </h1>
                        <p class="text-muted mb-0">
                            Gerencie as mensagens enviadas aos estudantes
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Card -->
        @if(!isset($student))
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title mb-0 text-primary">
                        <i class="fas fa-filter me-2"></i>Filtros de Pesquisa
                    </h5>
                    <div class="btn-group" role="group">
                        <button type="button" wire:click="exportPDF" class="btn btn-danger btn-sm">
                            <i class="fa fa-file-pdf me-1"></i>PDF
                        </button>
                        <button type="button" wire:click="exportExcel" class="btn btn-success btn-sm">
                            <i class="fa fa-file-excel me-1"></i>Excel
                        </button>
                    </div>
                </div>

                <div class="row g-3">
                    <div class="col-md-3">
                        <label for="selectedType" class="form-label">Tipo</label>
                        <select class="form-select" wire:model="selectedType" id="selectedType">
                            <option value="">Todos</option>
                            <option value="all">Todos os Estudantes</option>
                            <option value="class">Classe</option>
                            <option value="student">Estudante</option>
                            <option value="custom">Números Personalizados</option>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label for="selectedClass" class="form-label">Turma</label>
                        <select class="form-select" wire:model="selectedClass" id="selectedClass">
                            <option value="">Todas</option>
                            @foreach($classes as $class)
                                <option value="{{ $class->id }}">{{ $class->class }}ª - {{ $class->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label for="search" class="form-label">Pesquisar</label>
                        <input
                            type="search"
                            wire:model.debounce.300ms="search"
                            placeholder="Buscar por descrição..."
                            class="form-control"
                            id="search"
                        />
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Table Card -->
        <div class="card border-0 shadow-sm">
            <div class="card-body" wire:init="loadData">
                <div class="table-responsive">
                    @if(count($models))
                        <table class="table table-hover align-middle mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th style="width: 50px;">#</th>
                                    <th>Para</th>
                                    <th>Classe/Turma</th>
                                    <th>Estudante</th>
                                    <th>Descrição</th>
                                    <th>Estatísticas</th>
                                    <th>Ficheiro</th>
                                    <th>Data</th>
                                    @if(!isset($student))
                                    <th class="text-end pe-4" style="width: 100px;">Ações</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                            @php($count = 1)
                            @foreach($models as $model)
                                <?php
                                    $classroom = !empty($model->class_id) ? \App\Models\Classroom::find($model->class_id) : null;
                                    $student_user = !empty($model->student_id) ? \App\Models\User::find($model->student_id) : null;

                                    $typeLabel = '';
                                    $typeBadge = '';

                                    // Determine type label and badge
                                    if($model->type == "all") {
                                        $typeLabel = "Todos";
                                        $typeBadge = "bg-info";
                                    } elseif($model->type == "student") {
                                        $typeLabel = "Estudante";
                                        $typeBadge = "bg-warning";
                                    } elseif($model->type == "class") {
                                        $typeLabel = "Classe";
                                        $typeBadge = "bg-primary";
                                    } elseif($model->type == "custom") {
                                        $typeLabel = "Números Personalizados";
                                        $typeBadge = "bg-success";
                                    } else {
                                        // Default case for empty or unknown types
                                        $typeLabel = "Geral";
                                        $typeBadge = "bg-secondary";
                                    }

                                    // For student view, check if message is for them
                                    if(isset($student)) {
                                        $user = Auth::user();
                                        if(!empty($model->student_id) && $model->student_id != $user->id) {
                                            continue;
                                        }
                                    }
                                ?>
                                <tr style="transition: all 0.2s;">
                                    <td><span class="text-muted fw-bold">{{ $count++ }}</span></td>
                                    <td>
                                        <span class="badge {{ $typeBadge }}">{{ $typeLabel }}</span>
                                    </td>
                                    <td>
                                        @if($classroom)
                                            <span class="text-dark">{{ $classroom->class }}ª Classe - {{ $classroom->name }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($student_user)
                                            <strong>{{ $student_user->name }}</strong>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="mb-1">
                                            <span class="text-dark"
                                                  title="{{ strip_tags($model->title) }}"
                                                  style="cursor: help;">
                                                {!! Str::limit($model->title, 50) !!}
                                            </span>
                                        </div>
                                        @if($model->type == "custom" && !empty($model->description))
                                            <?php
                                                $numbers = explode(', ', $model->description);
                                                $displayCount = 3;
                                                $totalCount = count($numbers);
                                            ?>
                                            <div class="mt-1">
                                                <small class="text-muted d-block">
                                                    <i class="fas fa-phone-alt me-1"></i>
                                                    <strong>Números:</strong>
                                                    @if($totalCount <= $displayCount)
                                                        {{ $model->description }}
                                                    @else
                                                        {{ implode(', ', array_slice($numbers, 0, $displayCount)) }}
                                                        <span class="badge bg-secondary ms-1">+{{ $totalCount - $displayCount }} mais</span>
                                                    @endif
                                                </small>
                                            </div>
                                        @endif
                                    </td>
                                    <td>
                                        @if($model->total_sent > 0)
                                            <div class="d-flex flex-column gap-1">
                                                <small>
                                                    <i class="fas fa-paper-plane me-1 text-info"></i>
                                                    <strong>Total:</strong> {{ $model->total_sent }}
                                                </small>
                                                @if($model->success_count > 0)
                                                    <small class="text-success">
                                                        <i class="fas fa-check-circle me-1"></i>
                                                        <strong>Sucesso:</strong> {{ $model->success_count }}
                                                    </small>
                                                @endif
                                                @if($model->fail_count > 0)
                                                    <small class="text-danger">
                                                        <i class="fas fa-times-circle me-1"></i>
                                                        <strong>Falhas:</strong> {{ $model->fail_count }}
                                                    </small>
                                                @endif
                                            </div>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($model->media_url)
                                            <a href="{{ $model->media_url }}" target="_blank" class="text-primary">
                                                <i class="fas fa-file me-1"></i>{{ Str::limit($model->media_name, 20) }}
                                            </a>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <small class="text-muted">{{ $model->created_at->format('d/m/Y H:i') }}</small>
                                    </td>
                                    @if(!isset($student))
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <button type="button"
                                                    wire:click="submit('{{ $model->slug }}')"
                                                    class="btn btn-outline-danger btn-sm"
                                                    title="Deletar">
                                                <span class="fa fa-trash"></span>
                                            </button>
                                        </div>
                                    </td>
                                    @endif
                                </tr>
                            @endforeach
                            </tbody>
                        </table>

                        <div class="d-flex justify-content-center mt-3">
                            {{ $models->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div wire:loading class="spinner-border text-primary mb-3" role="status">
                                <span class="visually-hidden">Processando...</span>
                            </div>
                            <p class="text-muted"><strong>Nenhuma mensagem foi encontrada.</strong></p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <style>
        .table-hover tbody tr:hover {
            background-color: #f8f9fa;
            transform: translateY(-2px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .form-select:focus, .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }

        .btn-group-sm .btn {
            padding: 0.25rem 0.5rem;
        }
    </style>
</div>
