<div>
    <div class="page-heading">
        <div class="page-title">
            <div class="row">
                <div class="col-12 col-md-6 order-md-1 order-last">
                    <h3><i class="fa fa-percentage me-2"></i>Configuração de Taxa de IVA</h3>
                    <p class="text-subtitle text-muted">Gerir a taxa de IVA aplicada em todo o sistema</p>
                </div>
            </div>
        </div>
    </div>

    <div class="page-content">
        <section class="section">
            <div class="row">
                <div class="col-12 col-lg-8">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <h5 class="card-title text-white mb-0">
                                <i class="fa fa-calculator me-2"></i>Taxa de IVA Global
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle me-2"></i>
                                <strong>Informação:</strong> Esta taxa será aplicada a todas as transações que tenham o IVA ativado no sistema (POS, taxas escolares, certificados, etc.).
                            </div>

                            <form wire:submit.prevent="saveTaxRate">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="tax_rate" class="form-label">
                                                Taxa de IVA (%)
                                                <span class="text-danger">*</span>
                                            </label>
                                            <div class="input-group">
                                                <input
                                                    type="number"
                                                    class="form-control @error('tax_rate') is-invalid @enderror"
                                                    id="tax_rate"
                                                    wire:model.defer="tax_rate"
                                                    step="0.01"
                                                    min="0"
                                                    max="100"
                                                    placeholder="Ex: 17.00"
                                                >
                                                <span class="input-group-text">%</span>
                                                @error('tax_rate')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <small class="form-text text-muted">
                                                Taxa padrão em Moçambique: 16%
                                            </small>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mt-4">
                                    <div class="col-12">
                                        <div class="d-flex gap-2">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fa fa-save me-2"></i>Guardar Alterações
                                            </button>
                                            <button type="button" wire:click="resetToDefault" class="btn btn-outline-secondary">
                                                <i class="fa fa-undo me-2"></i>Repor Padrão (16%)
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-lg-4">
                    <div class="card">
                        <div class="card-header bg-light">
                            <h6 class="card-title mb-0">
                                <i class="fa fa-question-circle me-2"></i>Como Funciona
                            </h6>
                        </div>
                        <div class="card-body">
                            <h6 class="fw-bold">Taxa de IVA</h6>
                            <p class="small">A taxa de IVA configurada aqui será utilizada em todos os cálculos de IVA no sistema.</p>

                            <h6 class="fw-bold mt-3">Aplicação</h6>
                            <ul class="small">
                                <li>Vendas no POS</li>
                                <li>Taxas escolares</li>
                                <li>Certificados e declarações</li>
                                <li>Outros serviços com IVA ativado</li>
                            </ul>

                            <h6 class="fw-bold mt-3">Cálculo</h6>
                            <p class="small">
                                <strong>Preço inclui IVA:</strong><br>
                                IVA = Preço × (Taxa ÷ (100 + Taxa))
                            </p>
                            <p class="small">
                                <strong>Preço sem IVA:</strong><br>
                                IVA = Preço × (Taxa ÷ 100)
                            </p>

                            <div class="alert alert-warning mt-3 small">
                                <i class="fa fa-exclamation-triangle me-1"></i>
                                <strong>Atenção:</strong> Alterações na taxa de IVA afetarão apenas novos cálculos. Transações anteriores mantêm os valores já registados.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>
