<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Editar estudante</h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <label for="name" class="form-label">Nome completo</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror"
                                           id="name" required placeholder="Insira nome completo..." wire:model="name">
                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
  					<div class="col-md-6">
                                    <label for="phone_number" class="form-label">Número celular</label>
                                    <input type="text" class="form-control @error('phone_number') is-invalid @enderror"
                                           id="phone_number" required placeholder="Insira o numero celular..."
                                           wire:model="phone_number">
                                    @error('phone_number')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="sex" class="form-label">Sexo</label>
                                    <select class="form-control @error('sex') is-invalid @enderror"
                                            id="name" wire:model="sex"
                                            class="form-control input-lg dynamic">
                                        <option value="">Escolha o sexo</option>
                                            <option value="Masculino">Masculino</option>
                                            <option value="Feminino">Feminino</option>
                                    </select>
                                    @error('sex')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                    <div class="col-md-6">
                                    <label for="class" class="form-label">Classe</label>
                                    <select class="form-control @error('class') is-invalid @enderror"
                                            id="class" wire:model="class"
                                            class="form-control input-lg dynamic">
                                            <option value="">Por favor selecione a classe</option>
                                            <option value="1">1ª Classe</option>
                                            <option value="2">2ª Classe</option>
                                            <option value="3">3ª Classe</option>
                                            <option value="4">4ª Classe</option>
                                            <option value="5">5ª Classe</option>
                                            <option value="6">6ª Classe</option>
                                            <option value="7">7ª Classe</option>
                                            <option value="8">8ª Classe</option>
                                            <option value="9">9ª Classe</option>
                                            <option value="10">10ª Classe</option>
                                            <option value="11">11ª Classe</option>
                                            <option value="12">12ª Classe</option>
                                    </select>
                                    @error('class')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                   <label for="title" class="form-label">Turma</label>
                                    <select class="form-control @error('classroom_id') is-invalid @enderror"
                                            id="name" wire:model="classroom_id"
                                            class="form-control input-lg dynamic">
                                        <option value="">Selecione a turma</option>
                                        @foreach($classes as $class)
                                            <option value="{{ $class->id }}"> {{ $class->name }} </option>
                                        @endforeach
                                    </select>
                                    @error('classroom_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="email" class="form-label">Email</label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror"
                                           id="email" required placeholder="Insira o email..." wire:model="email">
                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="student_id" class="form-label">ID do Estudante</label>
                                    <input type="student_id"
                                           class="form-control @error('student_id') is-invalid @enderror"
                                           id="student_id" required placeholder="Insira o ID do Estudante..."
                                           wire:model="student_id">
                                    @error('student_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="dob" class="form-label">Data de nascimento</label>
                                    <input type="date"
                                           class="form-control @error('dob') is-invalid @enderror"
                                           id="dob" required placeholder="Insira data de nascimento..."
                                           wire:model="dob">
                                    @error('dob')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <!-- Separador para dados de filiação -->
                                <div class="col-12 mt-4">
                                    <h6 class="text-primary border-bottom pb-2">
                                        <i class="fas fa-users me-2"></i>Dados de Filiação e Naturalidade
                                    </h6>
                                </div>

                                <div class="col-md-6">
                                    <label for="father_name" class="form-label">Nome do Pai</label>
                                    <input type="text"
                                           class="form-control @error('father_name') is-invalid @enderror"
                                           id="father_name" placeholder="Nome do pai..."
                                           wire:model="father_name">
                                    @error('father_name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label for="mother_name" class="form-label">Nome da Mãe</label>
                                    <input type="text"
                                           class="form-control @error('mother_name') is-invalid @enderror"
                                           id="mother_name" placeholder="Nome da mãe..."
                                           wire:model="mother_name">
                                    @error('mother_name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-md-4">
                                    <label for="birth_place" class="form-label">Local de Nascimento</label>
                                    <input type="text"
                                           class="form-control @error('birth_place') is-invalid @enderror"
                                           id="birth_place" placeholder="Local de nascimento..."
                                           wire:model="birth_place">
                                    @error('birth_place')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-md-4">
                                    <label for="birth_district" class="form-label">Distrito de Nascimento</label>
                                    <input type="text"
                                           class="form-control @error('birth_district') is-invalid @enderror"
                                           id="birth_district" placeholder="Distrito de nascimento..."
                                           wire:model="birth_district">
                                    @error('birth_district')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-md-4">
                                    <label for="birth_province" class="form-label">Província de Nascimento</label>
                                    <select class="form-control @error('birth_province') is-invalid @enderror"
                                            id="birth_province" wire:model="birth_province">
                                        <option value="">Selecione...</option>
                                        <option value="Cabo Delgado">Cabo Delgado</option>
                                        <option value="Gaza">Gaza</option>
                                        <option value="Inhambane">Inhambane</option>
                                        <option value="Manica">Manica</option>
                                        <option value="Maputo">Maputo</option>
                                        <option value="Maputo Cidade">Maputo Cidade</option>
                                        <option value="Nampula">Nampula</option>
                                        <option value="Niassa">Niassa</option>
                                        <option value="Sofala">Sofala</option>
                                        <option value="Tete">Tete</option>
                                        <option value="Zambezia">Zambézia</option>
                                    </select>
                                    @error('birth_province')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <!-- Separador para documentação -->
                                <div class="col-12 mt-4">
                                    <h6 class="text-primary border-bottom pb-2">
                                        <i class="fas fa-id-card me-2"></i>Documentação e Foto
                                    </h6>
                                </div>

                                <!-- Upload de BI Opcional para Preenchimento Automático -->
                                <div class="col-12">
                                    <div class="alert alert-info border-0 shadow-sm">
                                        <div class="d-flex align-items-start">
                                            <i class="fas fa-magic fa-2x text-info me-3 mt-1"></i>
                                            <div class="flex-grow-1">
                                                <h6 class="alert-heading mb-2">
                                                    <strong>Atualizar Dados com BI (Opcional)</strong>
                                                </h6>
                                                <p class="mb-2 small">Carregue uma foto ou scan do Bilhete de Identidade para atualizar automaticamente os dados</p>

                                                <div class="mt-3">
                                                    <label for="bi_document" class="form-label fw-semibold small">
                                                        <i class="fas fa-upload me-1"></i>Carregar BI
                                                    </label>
                                                    <input type="file"
                                                           id="bi_document"
                                                           wire:model="bi_document"
                                                           class="form-control form-control-sm"
                                                           accept="image/*,.pdf">

                                                    <!-- Loading indicator -->
                                                    <div wire:loading wire:target="bi_document" class="mt-2">
                                                        <div class="d-flex align-items-center text-primary">
                                                            <div class="spinner-border spinner-border-sm me-2" role="status">
                                                                <span class="visually-hidden">Processando...</span>
                                                            </div>
                                                            <small><strong>Processando BI com OCR, aguarde...</strong></small>
                                                        </div>
                                                    </div>

                                                    @if($bi_processed)
                                                        <div class="alert alert-success mt-2 py-2 mb-0">
                                                            <small>
                                                                <i class="fas fa-check-circle me-1"></i>
                                                                <strong>Dados extraídos com sucesso!</strong> Verifique e corrija os campos abaixo se necessário.
                                                            </small>
                                                        </div>
                                                    @endif

                                                    @if($bi_document)
                                                        <div class="mt-2">
                                                            <small class="text-muted">
                                                                <i class="fas fa-file-image me-1"></i>
                                                                Arquivo: {{ $bi_document->getClientOriginalName() }}
                                                            </small>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <label for="document_type" class="form-label">Tipo de Documento</label>
                                    <select class="form-control @error('document_type') is-invalid @enderror"
                                            id="document_type" wire:model="document_type">
                                        <option value="">Selecione...</option>
                                        <option value="BI">Bilhete de Identidade</option>
                                        <option value="Cedula">Cédula Pessoal</option>
                                        <option value="Passaporte">Passaporte</option>
                                    </select>
                                    @error('document_type')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-md-4">
                                    <label for="document_id" class="form-label">Número do Documento</label>
                                    <input type="text"
                                           class="form-control @error('document_id') is-invalid @enderror"
                                           id="document_id" placeholder="Ex: 123456789A"
                                           wire:model="document_id">
                                    @error('document_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-md-4">
                                    <label for="avatar" class="form-label">Foto do Estudante</label>
                                    <input type="file"
                                           class="form-control @error('avatar') is-invalid @enderror"
                                           id="avatar"
                                           wire:model="avatar"
                                           accept="image/*,.pdf">
                                    @error('avatar')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                    <div wire:loading wire:target="avatar" class="text-info small mt-1">
                                        <span class="spinner-border spinner-border-sm"></span> Carregando...
                                    </div>
                                    <div class="mt-2">
                                        @if($avatar)
                                            <img src="{{ $avatar->temporaryUrl() }}" class="img-thumbnail" style="max-height: 150px; border: 2px solid #28a745;">
                                            <small class="text-success d-block">
                                                <i class="fas fa-check me-1"></i>Nova foto selecionada (irá substituir a atual)
                                            </small>
                                        @elseif($extracted_photo_path)
                                            <div class="alert alert-success py-2 px-3 mb-2">
                                                <small>
                                                    <i class="fas fa-check-circle me-1"></i>
                                                    <strong>Foto extraída do BI automaticamente</strong>
                                                </small>
                                            </div>
                                            <img src="{{ asset('storage/' . $extracted_photo_path) }}" class="img-thumbnail" style="max-height: 150px; border: 2px solid #28a745;">
                                            <small class="text-muted d-block mt-1">
                                                Pode fazer upload manual para substituir
                                            </small>
                                        @elseif($currentAvatar)
                                            <img src="{{ Storage::url($currentAvatar) }}" class="img-thumbnail" style="max-height: 150px;">
                                            <small class="text-muted d-block">Foto atual</small>
                                        @endif
                                    </div>
                                </div>

                                    <div class="col-12">
                                    <button type="button" wire:click="generateAndSendNewPassword" class="btn btn-danger">
                                        <i class="fas fa-key"></i>
                                        Gerar Nova Senha
                                    </button>

                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled"><span wire:target="submit"
                                                                               wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Guardar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <!-- PDF.js Library for BI Document Upload -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.min.js"></script>
    <script>
        // Configurar PDF.js worker
        if (typeof pdfjsLib !== 'undefined') {
            pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.worker.min.js';
        }

        let isConvertingPdf = false;

        document.addEventListener('livewire:load', function() {
            const biInput = document.getElementById('bi_document');
            
            if (!biInput) return;

            // Interceptar ANTES do Livewire processar (usando capture)
            biInput.addEventListener('change', async function(e) {
                const file = e.target.files[0];
                if (!file) return;

                // Se é PDF e ainda não estamos convertendo
                if (file.type === 'application/pdf' && !isConvertingPdf) {
                    e.stopImmediatePropagation(); // Impedir Livewire de processar
                    
                    try {
                        isConvertingPdf = true;

                        // Converter PDF para imagem
                        const imageFile = await convertPdfToImage(file);
                        
                        // Substituir o arquivo PDF pelo JPEG no input
                        const dataTransfer = new DataTransfer();
                        dataTransfer.items.add(imageFile);
                        biInput.files = dataTransfer.files;

                        // Disparar evento de mudança novamente (agora com imagem)
                        const newEvent = new Event('change', { bubbles: true });
                        biInput.dispatchEvent(newEvent);
                        
                        isConvertingPdf = false;
                    } catch (error) {
                        console.error('Erro ao converter PDF:', error);
                        alert('Erro ao converter PDF. Por favor, tire uma foto do BI ou use uma imagem (JPG/PNG).');
                        biInput.value = '';
                        isConvertingPdf = false;
                    }
                }
            }, true); // true = capture phase

            async function convertPdfToImage(pdfFile) {
                return new Promise(async (resolve, reject) => {
                    try {
                        // Ler PDF como ArrayBuffer
                        const arrayBuffer = await pdfFile.arrayBuffer();

                        // Carregar PDF
                        const pdf = await pdfjsLib.getDocument({ data: arrayBuffer }).promise;

                        // Pegar primeira página
                        const page = await pdf.getPage(1);

                        // Definir escala para alta resolução (300 DPI equivalente)
                        const scale = 3.0;
                        const viewport = page.getViewport({ scale: scale });

                        // Criar canvas
                        const canvas = document.createElement('canvas');
                        const context = canvas.getContext('2d');
                        canvas.width = viewport.width;
                        canvas.height = viewport.height;

                        // Renderizar PDF no canvas
                        await page.render({
                            canvasContext: context,
                            viewport: viewport
                        }).promise;

                        // Converter canvas para Blob
                        const blob = await new Promise(resolve => {
                            canvas.toBlob(resolve, 'image/jpeg', 0.95);
                        });

                        // Criar File a partir do Blob
                        const fileName = pdfFile.name.replace('.pdf', '.jpg');
                        const imageFile = new File([blob], fileName, { type: 'image/jpeg' });

                        resolve(imageFile);
                    } catch (error) {
                        reject(error);
                    }
                });
            }
        });
    </script>
