<div>
    <div class="page-sidebar">
        <ul class="list-unstyled accordion-menu">

            {{-- Painel --}}
            <li class="{{ request()->routeIs('guardian.dashboard') ? 'active-page' : '' }}">
                <a href="{{ route('guardian.dashboard') }}"><i data-feather="home"></i>Painel</a>
            </li>

            @if($activeStudent)
            {{-- Educando --}}
            <li class="{{ request()->routeIs('guardian.estudante', 'guardian.pagamentos', 'guardian.notas', 'guardian.presencas', 'guardian.comunicados') ? 'active-page' : '' }}" id="guardian-educando-menu">
                <a href="#" id="guardian-educando-toggle"><i data-feather="users"></i>Educando<i class="fas fa-chevron-right dropdown-icon"></i></a>
                <ul>
                    <li><a href="{{ route('guardian.estudante', $activeStudent->id) }}" class="{{ request()->routeIs('guardian.estudante') ? 'active' : '' }}"><i class="fas fa-user-graduate"></i>Resumo</a></li>
                    <li><a href="{{ route('guardian.pagamentos') }}" class="{{ request()->routeIs('guardian.pagamentos') ? 'active' : '' }}"><i class="fas fa-credit-card"></i>Pagamentos</a></li>
                    <li><a href="{{ route('guardian.notas') }}" class="{{ request()->routeIs('guardian.notas') ? 'active' : '' }}"><i class="fas fa-book-open"></i>Notas</a></li>
                    <li><a href="{{ route('guardian.presencas') }}" class="{{ request()->routeIs('guardian.presencas') ? 'active' : '' }}"><i class="fas fa-check-square"></i>Presenças</a></li>
                    <li><a href="{{ route('guardian.comunicados') }}" class="{{ request()->routeIs('guardian.comunicados') ? 'active' : '' }}"><i class="fas fa-bell"></i>Comunicados</a></li>
                </ul>
            </li>
            @endif

            {{-- Chat --}}
            <li class="{{ request()->routeIs('guardian.chat') ? 'active-page' : '' }}">
                <a href="{{ route('guardian.chat') }}"><i data-feather="message-circle"></i>Chat</a>
            </li>

            {{-- Perfil --}}
            <li class="{{ request()->routeIs('guardian.perfil') ? 'active-page' : '' }}">
                <a href="{{ route('guardian.perfil') }}"><i data-feather="settings"></i>Perfil</a>
            </li>

            {{-- Sair --}}
            <li>
                <a href="{{ route('guardian.logout') }}"><i data-feather="log-out"></i>Sair</a>
            </li>

        </ul>
    </div>

    <script>
        (function() {
            function init() {
                if (typeof feather !== 'undefined') feather.replace();
                // Only auto-open Educando submenu if we're on an Educando sub-page
                var menu = document.getElementById('guardian-educando-menu');
                if (menu && menu.classList.contains('active-page')) {
                    var toggle = document.getElementById('guardian-educando-toggle');
                    var sub = menu.querySelector('ul');
                    if (toggle && sub && (sub.offsetHeight === 0 || getComputedStyle(sub).display === 'none')) {
                        toggle.click();
                    }
                }
            }
            // Wait for all scripts to finish (main.min.js accordion init)
            window.addEventListener('load', function() {
                setTimeout(init, 50);
            });
        })();
    </script>
</div>
